/*
 * Decompiled with CFR 0.152.
 */
package org.hcl.helloApache;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.hcl.helloApache.FunctionWithException;
import org.hcl.helloApache.IPdfPart;
import org.hcl.helloApache.PdfBufferedImage;
import org.hcl.helloApache.PdfImage;
import org.hcl.helloApache.PdfText;

public class PdfBuilder {
    final List<IPdfPart> parts = new ArrayList<IPdfPart>();
    int pageNo = 0;
    PDType1Font font = PDType1Font.TIMES_ROMAN;
    int fontSize = 12;

    public static PdfBuilder builder() {
        return new PdfBuilder();
    }

    public List<IPdfPart> build() {
        return Collections.unmodifiableList(this.parts);
    }

    private PdfBuilder with(IPdfPart part) {
        this.parts.add(part);
        return this;
    }

    public PdfBuilder pageNo(int pageNo) {
        this.pageNo = pageNo;
        return this;
    }

    public PdfBuilder font(PDType1Font font) {
        this.font = font;
        return this;
    }

    public PdfBuilder fontSize(int fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public PdfBuilder addText(float x, float y, String text) {
        return this.with(new PdfText(x, y, this.pageNo, this.font, this.fontSize, text));
    }

    public PdfBuilder addImage(float x, float y, FunctionWithException<PDDocument, PDImageXObject> image) {
        return this.with(new PdfImage(x, y, this.pageNo, image));
    }

    public PdfBuilder addBufferedImage(float x, float y, BufferedImage image) {
        return this.with(new PdfBufferedImage(x, y, this.pageNo, image));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PdfBuilder)) {
            return false;
        }
        PdfBuilder other = (PdfBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageNo() != other.getPageNo()) {
            return false;
        }
        if (this.getFontSize() != other.getFontSize()) {
            return false;
        }
        List<IPdfPart> this$parts = this.getParts();
        List<IPdfPart> other$parts = other.getParts();
        if (this$parts == null ? other$parts != null : !((Object)this$parts).equals(other$parts)) {
            return false;
        }
        PDType1Font this$font = this.getFont();
        PDType1Font other$font = other.getFont();
        return !(this$font == null ? other$font != null : !this$font.equals(other$font));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PdfBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageNo();
        result = result * 59 + this.getFontSize();
        List<IPdfPart> $parts = this.getParts();
        result = result * 59 + ($parts == null ? 43 : ((Object)$parts).hashCode());
        PDType1Font $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        return result;
    }

    public List<IPdfPart> getParts() {
        return this.parts;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public PDType1Font getFont() {
        return this.font;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public String toString() {
        return "PdfBuilder(parts=" + this.getParts() + ", pageNo=" + this.getPageNo() + ", font=" + this.getFont() + ", fontSize=" + this.getFontSize() + ")";
    }
}

