/*
 * Decompiled with CFR 0.152.
 */
package org.hcl.helloApache;

import java.awt.image.BufferedImage;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.hcl.helloApache.ConsumerWithException;
import org.hcl.helloApache.IPdfPart;
import org.hcl.helloApache.IPdfPrinter;
import org.hcl.helloApache.PdfBufferedImage;
import org.hcl.helloApache.PdfImage;
import org.hcl.helloApache.PdfText;

class PdfPrinter
implements IPdfPrinter {
    private final PDDocument doc;

    void withStream(IPdfPart part, ConsumerWithException<PDPageContentStream> consumer) throws Exception {
        PDPage page = this.doc.getDocumentCatalog().getPages().get(part.getPageNo());
        try (PDPageContentStream contentStream = new PDPageContentStream(this.doc, page, PDPageContentStream.AppendMode.APPEND, true);){
            consumer.accept(contentStream);
        }
    }

    @Override
    public void addText(PdfText text) throws Exception {
        this.withStream(text, stream -> {
            stream.beginText();
            try {
                stream.setFont((PDFont)text.getFont(), (float)text.getFontSize());
                stream.newLineAtOffset(text.getX(), text.getY());
                stream.showText(text.getText());
            }
            finally {
                stream.endText();
            }
        });
    }

    @Override
    public void addBufferedImage(PdfBufferedImage image) throws Exception {
        this.withStream(image, stream -> {
            BufferedImage bufferedImage = image.getImage();
            PDImageXObject jpg = JPEGFactory.createFromImage((PDDocument)this.doc, (BufferedImage)bufferedImage);
            stream.drawImage(jpg, image.getX(), image.getY());
        });
    }

    @Override
    public void addImage(PdfImage image) throws Exception {
        this.withStream(image, stream -> stream.drawImage(image.getImage().apply(this.doc), image.getX(), image.getY()));
    }

    public PdfPrinter(PDDocument doc) {
        this.doc = doc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PdfPrinter)) {
            return false;
        }
        PdfPrinter other = (PdfPrinter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PDDocument this$doc = this.getDoc();
        PDDocument other$doc = other.getDoc();
        return !(this$doc == null ? other$doc != null : !this$doc.equals(other$doc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PdfPrinter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PDDocument $doc = this.getDoc();
        result = result * 59 + ($doc == null ? 43 : $doc.hashCode());
        return result;
    }

    public PDDocument getDoc() {
        return this.doc;
    }

    public String toString() {
        return "PdfPrinter(doc=" + this.getDoc() + ")";
    }
}

