/*
 * Decompiled with CFR 0.152.
 */
package org.hcl.pdftemplate;

import java.awt.image.BufferedImage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.hcl.pdftemplate.IPdfPart;
import org.hcl.pdftemplate.IPdfPrinter;

class PdfBufferedImage
implements IPdfPart {
    private final float x;
    private final float y;
    private final int pageNo;
    private final BufferedImage image;

    @Override
    public void print(IPdfPrinter printer, PDPageContentStream stream) throws Exception {
        printer.printBufferedImage(stream, this);
    }

    public PdfBufferedImage(float x, float y, int pageNo, BufferedImage image) {
        this.x = x;
        this.y = y;
        this.pageNo = pageNo;
        this.image = image;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PdfBufferedImage)) {
            return false;
        }
        PdfBufferedImage other = (PdfBufferedImage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (this.getPageNo() != other.getPageNo()) {
            return false;
        }
        BufferedImage this$image = this.getImage();
        BufferedImage other$image = other.getImage();
        return !(this$image == null ? other$image != null : !this$image.equals(other$image));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PdfBufferedImage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        result = result * 59 + this.getPageNo();
        BufferedImage $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        return result;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public int getPageNo() {
        return this.pageNo;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public String toString() {
        return "PdfBufferedImage(x=" + this.getX() + ", y=" + this.getY() + ", pageNo=" + this.getPageNo() + ", image=" + this.getImage() + ")";
    }
}

