/*
 * Decompiled with CFR 0.152.
 */
package org.hcl.pdftemplate;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.hcl.pdftemplate.ConsumerWithException;
import org.hcl.pdftemplate.IPdfPart;
import org.hcl.pdftemplate.PdfBufferedImage;
import org.hcl.pdftemplate.PdfImage;
import org.hcl.pdftemplate.PdfJFreeChart;
import org.hcl.pdftemplate.PdfPrinter;
import org.hcl.pdftemplate.PdfText;

public interface IPdfPrinter {
    public static void updateTemplate(String resource, List<IPdfPart> parts, ConsumerWithException<PDDocument> consumer) throws Exception {
        InputStream stream = IPdfPrinter.class.getResourceAsStream(resource);
        if (stream == null) {
            throw new IllegalArgumentException("Resource not found: " + resource);
        }
        try (PDDocument doc = PDDocument.load((InputStream)stream);){
            IPdfPrinter.print(doc, parts);
            consumer.accept(doc);
        }
    }

    public static void print(PDDocument doc, List<IPdfPart> parts) throws Exception {
        PdfPrinter printer = new PdfPrinter(doc);
        for (IPdfPart part : parts) {
            IPdfPrinter.withStream(doc, part.getPageNo(), stream -> part.print(printer, (PDPageContentStream)stream));
        }
    }

    public static void withStream(PDDocument doc, int pageNo, ConsumerWithException<PDPageContentStream> consumer) throws Exception {
        PDPage page = doc.getDocumentCatalog().getPages().get(pageNo);
        try (PDPageContentStream contentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, false, true);){
            consumer.accept(contentStream);
        }
    }

    public void printText(PDPageContentStream var1, PdfText var2) throws Exception;

    public void printImage(PDPageContentStream var1, PdfImage var2) throws Exception;

    public void printBufferedImage(PDPageContentStream var1, PdfBufferedImage var2) throws Exception;

    public void printJFreeChart(PDPageContentStream var1, PdfJFreeChart var2) throws IOException;
}

