/*
 * Decompiled with CFR 0.152.
 */
package org.hcl.pdftemplate;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.hcl.pdftemplate.IPdfPrinter;
import org.hcl.pdftemplate.PdfBufferedImage;
import org.hcl.pdftemplate.PdfImage;
import org.hcl.pdftemplate.PdfJFreeChart;
import org.hcl.pdftemplate.PdfText;

class PdfPrinter
implements IPdfPrinter {
    private final PDDocument doc;

    @Override
    public void printText(PDPageContentStream stream, PdfText text) throws Exception {
        stream.beginText();
        try {
            stream.setFont((PDFont)text.getFont(), (float)text.getFontSize());
            stream.newLineAtOffset(text.getX(), text.getY());
            stream.showText(text.getText());
        }
        finally {
            stream.endText();
        }
    }

    @Override
    public void printBufferedImage(PDPageContentStream stream, PdfBufferedImage image) throws Exception {
        BufferedImage bufferedImage = image.getImage();
        PDImageXObject jpg = JPEGFactory.createFromImage((PDDocument)this.doc, (BufferedImage)bufferedImage);
        stream.drawImage(jpg, image.getX(), image.getY());
    }

    @Override
    public void printImage(PDPageContentStream stream, PdfImage image) throws Exception {
        stream.drawImage(image.getImage().apply(this.doc), image.getX(), image.getY());
    }

    public static BufferedImage removeAlphaChannel(BufferedImage img, int color) {
        if (!img.getColorModel().hasAlpha()) {
            return img;
        }
        int width = img.getWidth();
        int height = img.getHeight();
        BufferedImage target = new BufferedImage(width, height, 1);
        Graphics2D g = target.createGraphics();
        g.setColor(new Color(color, false));
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        return target;
    }

    @Override
    public void printJFreeChart(PDPageContentStream stream, PdfJFreeChart pdfJFreeChart) throws IOException {
        BufferedImage rawImage = pdfJFreeChart.getChart().createBufferedImage(pdfJFreeChart.getWidth() * 3, pdfJFreeChart.getHeight() * 3);
        BufferedImage image = PdfPrinter.removeAlphaChannel(rawImage, Color.WHITE.getRGB());
        PDImageXObject jpg = JPEGFactory.createFromImage((PDDocument)this.doc, (BufferedImage)image);
        stream.drawImage(jpg, pdfJFreeChart.getX(), pdfJFreeChart.getY(), (float)pdfJFreeChart.getWidth(), (float)pdfJFreeChart.getHeight());
    }

    public PdfPrinter(PDDocument doc) {
        this.doc = doc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PdfPrinter)) {
            return false;
        }
        PdfPrinter other = (PdfPrinter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PDDocument this$doc = this.getDoc();
        PDDocument other$doc = other.getDoc();
        return !(this$doc == null ? other$doc != null : !this$doc.equals(other$doc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PdfPrinter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PDDocument $doc = this.getDoc();
        result = result * 59 + ($doc == null ? 43 : $doc.hashCode());
        return result;
    }

    public PDDocument getDoc() {
        return this.doc;
    }

    public String toString() {
        return "PdfPrinter(doc=" + this.getDoc() + ")";
    }
}

