/*
 * Decompiled with CFR 0.152.
 */
package org.hcl.helloApache;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.hcl.helloApache.FunctionWithException;
import org.hcl.helloApache.IPdfPart;
import org.hcl.helloApache.IPdfPrinter;

class PdfImage
implements IPdfPart {
    private final float x;
    private final float y;
    private final int pageNo;
    private final FunctionWithException<PDDocument, PDImageXObject> image;

    @Override
    public void print(IPdfPrinter builder) throws Exception {
        builder.addImage(this);
    }

    public PdfImage(float x, float y, int pageNo, FunctionWithException<PDDocument, PDImageXObject> image) {
        this.x = x;
        this.y = y;
        this.pageNo = pageNo;
        this.image = image;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PdfImage)) {
            return false;
        }
        PdfImage other = (PdfImage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (this.getPageNo() != other.getPageNo()) {
            return false;
        }
        FunctionWithException<PDDocument, PDImageXObject> this$image = this.getImage();
        FunctionWithException<PDDocument, PDImageXObject> other$image = other.getImage();
        return !(this$image == null ? other$image != null : !this$image.equals(other$image));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PdfImage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        result = result * 59 + this.getPageNo();
        FunctionWithException<PDDocument, PDImageXObject> $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        return result;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public int getPageNo() {
        return this.pageNo;
    }

    public FunctionWithException<PDDocument, PDImageXObject> getImage() {
        return this.image;
    }

    public String toString() {
        return "PdfImage(x=" + this.getX() + ", y=" + this.getY() + ", pageNo=" + this.getPageNo() + ", image=" + this.getImage() + ")";
    }
}

