/*
 * Decompiled with CFR 0.152.
 */
package org.hcl.pdftemplate;

import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.hcl.pdftemplate.FunctionWithException;
import org.hcl.pdftemplate.IPdfPart;
import org.hcl.pdftemplate.IPdfPrinter;

class PdfText<Data>
implements IPdfPart<Data> {
    private final float x;
    private final float y;
    private final int pageNo;
    private final PDType1Font font;
    private final int fontSize;
    private final FunctionWithException<Data, String> text;

    @Override
    public void print(IPdfPrinter printer, PDPageContentStream stream, Data data) throws Exception {
        printer.printText(stream, data, this);
    }

    public PdfText(float x, float y, int pageNo, PDType1Font font, int fontSize, FunctionWithException<Data, String> text) {
        this.x = x;
        this.y = y;
        this.pageNo = pageNo;
        this.font = font;
        this.fontSize = fontSize;
        this.text = text;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PdfText)) {
            return false;
        }
        PdfText other = (PdfText)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (this.getPageNo() != other.getPageNo()) {
            return false;
        }
        if (this.getFontSize() != other.getFontSize()) {
            return false;
        }
        PDType1Font this$font = this.getFont();
        PDType1Font other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        FunctionWithException<Data, String> this$text = this.getText();
        FunctionWithException<Data, String> other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PdfText;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        result = result * 59 + this.getPageNo();
        result = result * 59 + this.getFontSize();
        PDType1Font $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        FunctionWithException<Data, String> $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public int getPageNo() {
        return this.pageNo;
    }

    public PDType1Font getFont() {
        return this.font;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public FunctionWithException<Data, String> getText() {
        return this.text;
    }

    public String toString() {
        return "PdfText(x=" + this.getX() + ", y=" + this.getY() + ", pageNo=" + this.getPageNo() + ", font=" + this.getFont() + ", fontSize=" + this.getFontSize() + ", text=" + this.getText() + ")";
    }
}

