/*
 * Decompiled with CFR 0.152.
 */
package org.hcl.pdftemplate.freeChart;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import one.xingyi.optics.IFold;
import one.xingyi.tuples.Tuple2;
import org.hcl.pdftemplate.FunctionWithException;
import org.hcl.pdftemplate.freeChart.DateAndValueGraphDefn;
import org.hcl.pdftemplate.freeChart.IMakeJFreeChart;
import org.hcl.pdftemplate.freeChart.SeriesDefn;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.RegularTimePeriod;

public class ChartBuilder<Data, XData> {
    Class<XData> xDataClass;
    String title = "";
    String subTitle = "";
    String xAxis = "Date";
    String yAxis = "Value";
    boolean showXLines = false;
    boolean showYLines = false;
    Float seriesStrokeWidth = Float.valueOf(2.0f);
    List<SeriesDefn<Data, XData>> seriesDefns = new ArrayList<SeriesDefn<Data, XData>>();

    public static <Data> ChartBuilder<Data, RegularTimePeriod> forDataChart(String title, String yAxis) {
        ChartBuilder result = new ChartBuilder();
        result.xDataClass = RegularTimePeriod.class;
        result.title = title;
        result.yAxis = yAxis;
        return result;
    }

    public ChartBuilder<Data, XData> subTitle(String subTitle) {
        this.subTitle = subTitle;
        return this;
    }

    public ChartBuilder<Data, XData> xAxis(String xAxis) {
        this.xAxis = xAxis;
        return this;
    }

    public ChartBuilder<Data, XData> showXLines(boolean showXLines) {
        this.showXLines = showXLines;
        return this;
    }

    public ChartBuilder<Data, XData> showYLines(boolean showYLines) {
        this.showYLines = showYLines;
        return this;
    }

    public ChartBuilder<Data, XData> seriesStrokeWidth(Float seriesStrokeWidth) {
        this.seriesStrokeWidth = seriesStrokeWidth;
        return this;
    }

    public ChartBuilder<Data, XData> addSeries(String seriesName, Color color, IFold<Data, Tuple2<XData, Double>> dataFn) {
        this.seriesDefns.add(new SeriesDefn<Data, XData>(seriesName, color, dataFn, this.seriesStrokeWidth));
        return this;
    }

    public FunctionWithException<Data, JFreeChart> build() {
        return this.build(IMakeJFreeChart.getInstance());
    }

    public FunctionWithException<Data, DateAndValueGraphDefn<Data, XData>> buildDefn() {
        return data -> new DateAndValueGraphDefn<Data, XData>(this.title, this.subTitle, this.xAxis, this.yAxis, this.showXLines, this.showYLines, this.seriesDefns);
    }

    public FunctionWithException<Data, JFreeChart> build(IMakeJFreeChart makeJFreeChart) {
        if (this.xDataClass != RegularTimePeriod.class) {
            throw new RuntimeException("Only RegularTimePeriod is supported");
        }
        FunctionWithException<Data, DateAndValueGraphDefn<Data, XData>> result = this.buildDefn();
        FunctionWithException<Data, DateAndValueGraphDefn<Data, XData>> cast = this.buildDefn();
        return makeJFreeChart.makeTimeChart(cast);
    }

    public String toString() {
        return "ChartBuilder(xDataClass=" + this.xDataClass + ", title=" + this.title + ", subTitle=" + this.subTitle + ", xAxis=" + this.xAxis + ", yAxis=" + this.yAxis + ", showXLines=" + this.showXLines + ", showYLines=" + this.showYLines + ", seriesStrokeWidth=" + this.seriesStrokeWidth + ", seriesDefns=" + this.seriesDefns + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChartBuilder)) {
            return false;
        }
        ChartBuilder other = (ChartBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.showXLines != other.showXLines) {
            return false;
        }
        if (this.showYLines != other.showYLines) {
            return false;
        }
        Float this$seriesStrokeWidth = this.seriesStrokeWidth;
        Float other$seriesStrokeWidth = other.seriesStrokeWidth;
        if (this$seriesStrokeWidth == null ? other$seriesStrokeWidth != null : !((Object)this$seriesStrokeWidth).equals(other$seriesStrokeWidth)) {
            return false;
        }
        Class<XData> this$xDataClass = this.xDataClass;
        Class<XData> other$xDataClass = other.xDataClass;
        if (this$xDataClass == null ? other$xDataClass != null : !this$xDataClass.equals(other$xDataClass)) {
            return false;
        }
        String this$title = this.title;
        String other$title = other.title;
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$subTitle = this.subTitle;
        String other$subTitle = other.subTitle;
        if (this$subTitle == null ? other$subTitle != null : !this$subTitle.equals(other$subTitle)) {
            return false;
        }
        String this$xAxis = this.xAxis;
        String other$xAxis = other.xAxis;
        if (this$xAxis == null ? other$xAxis != null : !this$xAxis.equals(other$xAxis)) {
            return false;
        }
        String this$yAxis = this.yAxis;
        String other$yAxis = other.yAxis;
        if (this$yAxis == null ? other$yAxis != null : !this$yAxis.equals(other$yAxis)) {
            return false;
        }
        List<SeriesDefn<Data, XData>> this$seriesDefns = this.seriesDefns;
        List<SeriesDefn<Data, XData>> other$seriesDefns = other.seriesDefns;
        return !(this$seriesDefns == null ? other$seriesDefns != null : !((Object)this$seriesDefns).equals(other$seriesDefns));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChartBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.showXLines ? 79 : 97);
        result = result * 59 + (this.showYLines ? 79 : 97);
        Float $seriesStrokeWidth = this.seriesStrokeWidth;
        result = result * 59 + ($seriesStrokeWidth == null ? 43 : ((Object)$seriesStrokeWidth).hashCode());
        Class<XData> $xDataClass = this.xDataClass;
        result = result * 59 + ($xDataClass == null ? 43 : $xDataClass.hashCode());
        String $title = this.title;
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $subTitle = this.subTitle;
        result = result * 59 + ($subTitle == null ? 43 : $subTitle.hashCode());
        String $xAxis = this.xAxis;
        result = result * 59 + ($xAxis == null ? 43 : $xAxis.hashCode());
        String $yAxis = this.yAxis;
        result = result * 59 + ($yAxis == null ? 43 : $yAxis.hashCode());
        List<SeriesDefn<Data, XData>> $seriesDefns = this.seriesDefns;
        result = result * 59 + ($seriesDefns == null ? 43 : ((Object)$seriesDefns).hashCode());
        return result;
    }
}

