/*
 * Decompiled with CFR 0.152.
 */
package org.hcl.pdftemplate.freeChart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Arrays;
import java.util.function.Function;
import org.hcl.pdftemplate.FunctionWithException;
import org.hcl.pdftemplate.freeChart.DateAndValueGraphDefn;
import org.hcl.pdftemplate.freeChart.IMakeJFreeChart;
import org.hcl.pdftemplate.freeChart.SeriesDefn;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

class MakeJFreeChart
implements IMakeJFreeChart {
    MakeJFreeChart() {
    }

    @Override
    public <Data> FunctionWithException<Data, JFreeChart> makeTimeChart(FunctionWithException<Data, DateAndValueGraphDefn<Data, RegularTimePeriod>> defnFn) {
        return data -> {
            DateAndValueGraphDefn defn = (DateAndValueGraphDefn)defnFn.apply(data);
            TimeSeriesCollection dataset = this.makeTimeDataSet(defn).apply(data);
            JFreeChart chart = ChartFactory.createTimeSeriesChart((String)defn.title, (String)defn.xAxis, (String)defn.yAxis, (XYDataset)dataset);
            XYPlot plot = chart.getXYPlot();
            XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
            for (int i = 0; i < dataset.getSeriesCount(); ++i) {
                SeriesDefn seriesDefn = defn.seriesDefns.get(i);
                renderer.setSeriesPaint(i, (Paint)seriesDefn.seriesColor);
                renderer.setSeriesStroke(i, (Stroke)new BasicStroke(seriesDefn.seriesStrokeWidth.floatValue()));
            }
            plot.setRenderer((XYItemRenderer)renderer);
            plot.setBackgroundPaint((Paint)Color.white);
            if (defn.showYLines) {
                plot.setRangeGridlinesVisible(true);
                plot.setRangeGridlinePaint((Paint)Color.lightGray);
            }
            if (defn.showXLines) {
                plot.setDomainGridlinesVisible(true);
                plot.setDomainGridlinePaint((Paint)Color.lightGray);
            }
            chart.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
            chart.setTitle(new TextTitle(defn.title, new Font("Serif", 1, 18)));
            if (defn.subTitle != null && defn.subTitle.length() > 0) {
                chart.setSubtitles(Arrays.asList(new TextTitle(defn.subTitle, new Font("Serif", 0, 12))));
            }
            return chart;
        };
    }

    <Data> Function<Data, TimeSeriesCollection> makeTimeDataSet(DateAndValueGraphDefn<Data, RegularTimePeriod> defn) {
        return data -> {
            TimeSeriesCollection result = new TimeSeriesCollection();
            defn.seriesDefns.stream().map(seriesDefn -> {
                TimeSeries series = new TimeSeries((Comparable)((Object)seriesDefn.seriesName));
                seriesDefn.dataFn.all(data).forEach(t -> series.add((RegularTimePeriod)t.t1, (Number)t.t2));
                return series;
            }).forEach(arg_0 -> ((TimeSeriesCollection)result).addSeries(arg_0));
            return result;
        };
    }
}

