/*
 * Decompiled with CFR 0.152.
 */
package org.hcl.pdftemplate;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.hcl.pdftemplate.BiFunctionWithException;
import org.hcl.pdftemplate.FunctionWithException;
import org.hcl.pdftemplate.part.IPdfPart;
import org.hcl.pdftemplate.part.PdfBufferedImage;
import org.hcl.pdftemplate.part.PdfImage;
import org.hcl.pdftemplate.part.PdfJFreeChart;
import org.hcl.pdftemplate.part.PdfText;
import org.jfree.chart.JFreeChart;

public class PdfBuilder<Data> {
    final List<IPdfPart<Data>> parts = new ArrayList<IPdfPart<Data>>();
    int pageNo = 0;
    PDType1Font font = PDType1Font.TIMES_ROMAN;
    int fontSize = 12;

    public static <Data> PdfBuilder<Data> builder() {
        return new PdfBuilder<Data>();
    }

    public List<IPdfPart<Data>> build() {
        return Collections.unmodifiableList(this.parts);
    }

    private PdfBuilder<Data> with(IPdfPart<Data> part) {
        this.parts.add(part);
        return this;
    }

    public PdfBuilder<Data> pageNo(int pageNo) {
        this.pageNo = pageNo;
        return this;
    }

    public PdfBuilder<Data> font(PDType1Font font) {
        this.font = font;
        return this;
    }

    public PdfBuilder<Data> fontSize(int fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public PdfBuilder<Data> addText(float x, float y, FunctionWithException<Data, String> text) {
        return this.with(new PdfText<Data>(x, y, this.pageNo, this.font, this.fontSize, text));
    }

    public PdfBuilder<Data> addParts(FunctionWithException<PdfBuilder<Data>, PdfBuilder<Data>> fn) throws Exception {
        return fn.apply(this);
    }

    public PdfBuilder<Data> addJfreeChart(float x, float y, FunctionWithException<Data, JFreeChart> chart) {
        return this.addJfreeChart(x, y, 300, 200, chart);
    }

    public PdfBuilder<Data> addJfreeChartAndImage(float x, float y, FunctionWithException<Data, JFreeChart> chart, float xOffset, float yOffset, FunctionWithException<Data, BufferedImage> image) {
        return this.addJfreeChart(x, y, 300, 200, chart).addBufferedImage(x + xOffset, y + yOffset, image);
    }

    public PdfBuilder<Data> addJfreeChart(float x, float y, int width, int height, FunctionWithException<Data, JFreeChart> chart) {
        return this.with(new PdfJFreeChart<Data>(x, y, width, height, this.pageNo, chart));
    }

    public PdfBuilder<Data> addImage(float x, float y, BiFunctionWithException<PDDocument, Data, PDImageXObject> image) {
        return this.with(new PdfImage<Data>(x, y, this.pageNo, image));
    }

    public PdfBuilder<Data> addBufferedImage(float x, float y, FunctionWithException<Data, BufferedImage> image) {
        return this.with(new PdfBufferedImage<Data>(x, y, this.pageNo, image));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PdfBuilder)) {
            return false;
        }
        PdfBuilder other = (PdfBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageNo() != other.getPageNo()) {
            return false;
        }
        if (this.getFontSize() != other.getFontSize()) {
            return false;
        }
        List<IPdfPart<Data>> this$parts = this.getParts();
        List<IPdfPart<Data>> other$parts = other.getParts();
        if (this$parts == null ? other$parts != null : !((Object)this$parts).equals(other$parts)) {
            return false;
        }
        PDType1Font this$font = this.getFont();
        PDType1Font other$font = other.getFont();
        return !(this$font == null ? other$font != null : !this$font.equals(other$font));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PdfBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPageNo();
        result = result * 59 + this.getFontSize();
        List<IPdfPart<Data>> $parts = this.getParts();
        result = result * 59 + ($parts == null ? 43 : ((Object)$parts).hashCode());
        PDType1Font $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        return result;
    }

    public List<IPdfPart<Data>> getParts() {
        return this.parts;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public PDType1Font getFont() {
        return this.font;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public String toString() {
        return "PdfBuilder(parts=" + this.getParts() + ", pageNo=" + this.getPageNo() + ", font=" + this.getFont() + ", fontSize=" + this.getFontSize() + ")";
    }
}

