/*
 * Decompiled with CFR 0.152.
 */
package org.hcl.pdftemplate;

import java.awt.Color;
import java.awt.image.BufferedImage;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.hcl.pdftemplate.IPdfPrinter;
import org.hcl.pdftemplate.freeChart.BufferedImageUtils;
import org.hcl.pdftemplate.part.PdfBufferedImage;
import org.hcl.pdftemplate.part.PdfImage;
import org.hcl.pdftemplate.part.PdfJFreeChart;
import org.hcl.pdftemplate.part.PdfText;

class PdfPrinter
implements IPdfPrinter {
    private final PDDocument doc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Data> void printText(PDPageContentStream stream, Data data, PdfText<Data> text) throws Exception {
        stream.beginText();
        try {
            stream.setFont((PDFont)text.getFont(), (float)text.getFontSize());
            stream.newLineAtOffset(text.getX(), text.getY());
            String toDisplay = text.getText().apply(data);
            if (toDisplay != null) {
                stream.showText(toDisplay);
            }
        }
        finally {
            stream.endText();
        }
    }

    @Override
    public <Data> void printBufferedImage(PDPageContentStream stream, Data data, PdfBufferedImage<Data> image) throws Exception {
        BufferedImage bufferedImage = image.getImage().apply(data);
        PDImageXObject jpg = JPEGFactory.createFromImage((PDDocument)this.doc, (BufferedImage)bufferedImage);
        stream.drawImage(jpg, image.getX(), image.getY());
    }

    @Override
    public <Data> void printImage(PDPageContentStream stream, Data data, PdfImage<Data> image) throws Exception {
        stream.drawImage(image.getImage().apply(this.doc, data), image.getX(), image.getY());
    }

    @Override
    public <Data> void printJFreeChart(PDPageContentStream stream, Data data, PdfJFreeChart<Data> pdfJFreeChart) throws Exception {
        BufferedImage rawImage = pdfJFreeChart.getChart().apply(data).createBufferedImage(pdfJFreeChart.getWidth() * 3, pdfJFreeChart.getHeight() * 3);
        BufferedImage image = BufferedImageUtils.removeAlphaChannel(rawImage, Color.WHITE.getRGB());
        PDImageXObject jpg = JPEGFactory.createFromImage((PDDocument)this.doc, (BufferedImage)image);
        stream.drawImage(jpg, pdfJFreeChart.getX(), pdfJFreeChart.getY(), (float)pdfJFreeChart.getWidth(), (float)pdfJFreeChart.getHeight());
    }

    public PdfPrinter(PDDocument doc) {
        this.doc = doc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PdfPrinter)) {
            return false;
        }
        PdfPrinter other = (PdfPrinter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PDDocument this$doc = this.getDoc();
        PDDocument other$doc = other.getDoc();
        return !(this$doc == null ? other$doc != null : !this$doc.equals(other$doc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PdfPrinter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PDDocument $doc = this.getDoc();
        result = result * 59 + ($doc == null ? 43 : $doc.hashCode());
        return result;
    }

    public PDDocument getDoc() {
        return this.doc;
    }

    public String toString() {
        return "PdfPrinter(doc=" + this.getDoc() + ")";
    }
}

