/*
 * Decompiled with CFR 0.152.
 */
package org.hcl.pdftemplate;

import java.io.InputStream;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.hcl.pdftemplate.BiConsumerWithException;
import org.hcl.pdftemplate.ConsumerWithException;
import org.hcl.pdftemplate.FunctionWithException;
import org.hcl.pdftemplate.PdfPrinter;
import org.hcl.pdftemplate.part.IPdfPart;
import org.hcl.pdftemplate.part.PdfBufferedImage;
import org.hcl.pdftemplate.part.PdfImage;
import org.hcl.pdftemplate.part.PdfJFreeChart;
import org.hcl.pdftemplate.part.PdfText;

public interface IPdfPrinter {
    public static <Data, To> FunctionWithException<Data, To> processTemplateAndReturn(String resource, List<IPdfPart<Data>> parts, FunctionWithException<PDDocument, To> consumer) {
        return data -> {
            InputStream stream = IPdfPrinter.class.getResourceAsStream(resource);
            if (stream == null) {
                throw new IllegalArgumentException("Resource not found: " + resource);
            }
            try (PDDocument doc = PDDocument.load((InputStream)stream);){
                IPdfPrinter.print(doc, data, parts);
                Object To = consumer.apply(doc);
                return To;
            }
        };
    }

    public static <Data> BiConsumerWithException<Data, ConsumerWithException<PDDocument>> processTemplate(String resource, List<IPdfPart<Data>> parts) {
        return (data, consumer) -> {
            InputStream stream = IPdfPrinter.class.getResourceAsStream(resource);
            if (stream == null) {
                throw new IllegalArgumentException("Resource not found: " + resource);
            }
            try (PDDocument doc = PDDocument.load((InputStream)stream);){
                IPdfPrinter.print(doc, data, parts);
                consumer.accept(doc);
            }
        };
    }

    public static <Data> void print(PDDocument doc, Data data, List<IPdfPart<Data>> parts) throws Exception {
        PdfPrinter printer = new PdfPrinter(doc);
        for (IPdfPart part : parts) {
            IPdfPrinter.withStream(doc, part.getPageNo(), stream -> part.print(printer, (PDPageContentStream)stream, data));
        }
    }

    public static void withStream(PDDocument doc, int pageNo, ConsumerWithException<PDPageContentStream> consumer) throws Exception {
        PDPage page = doc.getDocumentCatalog().getPages().get(pageNo);
        try (PDPageContentStream contentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, false, true);){
            consumer.accept(contentStream);
        }
    }

    public <Data> void printText(PDPageContentStream var1, Data var2, PdfText<Data> var3) throws Exception;

    public <Data> void printImage(PDPageContentStream var1, Data var2, PdfImage<Data> var3) throws Exception;

    public <Data> void printBufferedImage(PDPageContentStream var1, Data var2, PdfBufferedImage<Data> var3) throws Exception;

    public <Data> void printJFreeChart(PDPageContentStream var1, Data var2, PdfJFreeChart<Data> var3) throws Exception;
}

