/*
 * Decompiled with CFR 0.152.
 */
package org.hcl.pdftemplate.part;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.hcl.pdftemplate.BiFunctionWithException;
import org.hcl.pdftemplate.IPdfPrinter;
import org.hcl.pdftemplate.part.IPdfPart;

public class PdfImage<Data>
implements IPdfPart<Data> {
    private final float x;
    private final float y;
    private final int pageNo;
    private final BiFunctionWithException<PDDocument, Data, PDImageXObject> image;

    @Override
    public void print(IPdfPrinter printer, PDPageContentStream stream, Data data) throws Exception {
        printer.printImage(stream, data, this);
    }

    public PdfImage(float x, float y, int pageNo, BiFunctionWithException<PDDocument, Data, PDImageXObject> image) {
        this.x = x;
        this.y = y;
        this.pageNo = pageNo;
        this.image = image;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PdfImage)) {
            return false;
        }
        PdfImage other = (PdfImage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (this.getPageNo() != other.getPageNo()) {
            return false;
        }
        BiFunctionWithException<PDDocument, Data, PDImageXObject> this$image = this.getImage();
        BiFunctionWithException<PDDocument, Data, PDImageXObject> other$image = other.getImage();
        return !(this$image == null ? other$image != null : !this$image.equals(other$image));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PdfImage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        result = result * 59 + this.getPageNo();
        BiFunctionWithException<PDDocument, Data, PDImageXObject> $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        return result;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public int getPageNo() {
        return this.pageNo;
    }

    public BiFunctionWithException<PDDocument, Data, PDImageXObject> getImage() {
        return this.image;
    }

    public String toString() {
        return "PdfImage(x=" + this.getX() + ", y=" + this.getY() + ", pageNo=" + this.getPageNo() + ", image=" + this.getImage() + ")";
    }
}

