/*
 * Decompiled with CFR 0.152.
 */
package org.hcl.pdftemplate.freeChart;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import one.xingyi.tuples.Tuple2;

public class ColorRange {
    final Color defaultColour;
    final List<Tuple2<Double, Color>> sortedcolours;

    public static ColorRange create(Color defaultColour) {
        return new ColorRange(defaultColour, new ArrayList<Tuple2<Double, Color>>());
    }

    public ColorRange add(double y, Color color) {
        this.sortedcolours.add((Tuple2<Double, Color>)Tuple2.of((Object)y, (Object)color));
        this.sortedcolours.sort((t1, t2) -> ((Double)t1.t1).compareTo((Double)t2.t1));
        return this;
    }

    public Color getColor(double y) {
        for (Tuple2<Double, Color> t : this.sortedcolours) {
            if (!(y <= (Double)t.t1)) continue;
            return (Color)t.t2;
        }
        return this.defaultColour;
    }

    public ColorRange(Color defaultColour, List<Tuple2<Double, Color>> sortedcolours) {
        this.defaultColour = defaultColour;
        this.sortedcolours = sortedcolours;
    }

    public String toString() {
        return "ColorRange(defaultColour=" + this.defaultColour + ", sortedcolours=" + this.sortedcolours + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColorRange)) {
            return false;
        }
        ColorRange other = (ColorRange)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Color this$defaultColour = this.defaultColour;
        Color other$defaultColour = other.defaultColour;
        if (this$defaultColour == null ? other$defaultColour != null : !((Object)this$defaultColour).equals(other$defaultColour)) {
            return false;
        }
        List<Tuple2<Double, Color>> this$sortedcolours = this.sortedcolours;
        List<Tuple2<Double, Color>> other$sortedcolours = other.sortedcolours;
        return !(this$sortedcolours == null ? other$sortedcolours != null : !((Object)this$sortedcolours).equals(other$sortedcolours));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ColorRange;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Color $defaultColour = this.defaultColour;
        result = result * 59 + ($defaultColour == null ? 43 : ((Object)$defaultColour).hashCode());
        List<Tuple2<Double, Color>> $sortedcolours = this.sortedcolours;
        result = result * 59 + ($sortedcolours == null ? 43 : ((Object)$sortedcolours).hashCode());
        return result;
    }
}

