/*
 * Decompiled with CFR 0.152.
 */
package org.hcl.pdftemplate.freeChart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.Arrays;
import java.util.function.Function;
import org.hcl.pdftemplate.FunctionWithException;
import org.hcl.pdftemplate.freeChart.DateAndValueGraphDefn;
import org.hcl.pdftemplate.freeChart.IMakeJFreeChart;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

class MakeJFreeChart
implements IMakeJFreeChart {
    private static ChartTheme currentTheme = new StandardChartTheme("JFree");

    MakeJFreeChart() {
    }

    public static JFreeChart createTimeSeriesChart(String title, ValueAxis xAxis, ValueAxis yAxis, XYDataset dataset, boolean legend) {
        XYPlot plot = new XYPlot(dataset, xAxis, yAxis, null);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
        currentTheme.apply(chart);
        return chart;
    }

    @Override
    public <Data> FunctionWithException<Data, JFreeChart> makeTimeChart(FunctionWithException<Data, DateAndValueGraphDefn<Data, RegularTimePeriod>> defnFn) {
        return data -> {
            String subTitle;
            DateAndValueGraphDefn defn = (DateAndValueGraphDefn)defnFn.apply(data);
            TimeSeriesCollection dataset = this.makeTimeDataSet(defn).apply(data);
            String title = defn.title.apply(data);
            JFreeChart chart = MakeJFreeChart.createTimeSeriesChart(title, defn.xAxis.apply(data), defn.yAxis.apply(data), (XYDataset)dataset, defn.legend);
            XYPlot plot = chart.getXYPlot();
            AbstractXYItemRenderer renderer = defn.renderer.apply(defn.seriesDefns, (XYDataset)dataset);
            if (renderer != null) {
                plot.setRenderer((XYItemRenderer)renderer);
            }
            plot.setBackgroundPaint((Paint)Color.white);
            defn.modifyPlot.accept(plot);
            if (defn.showYLines) {
                plot.setRangeGridlinesVisible(true);
                plot.setRangeGridlinePaint((Paint)Color.lightGray);
            }
            if (defn.showXLines) {
                plot.setDomainGridlinesVisible(true);
                plot.setDomainGridlinePaint((Paint)Color.lightGray);
            }
            if (defn.legend) {
                chart.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
            }
            if ((subTitle = defn.subTitle.apply(data)) != null && subTitle.length() > 0) {
                chart.setSubtitles(Arrays.asList(new TextTitle(subTitle, new Font("Serif", 0, 12))));
            }
            return chart;
        };
    }

    <Data> Function<Data, TimeSeriesCollection> makeTimeDataSet(DateAndValueGraphDefn<Data, RegularTimePeriod> defn) {
        return data -> {
            TimeSeriesCollection result = new TimeSeriesCollection();
            defn.seriesDefns.stream().map(seriesDefn -> {
                TimeSeries series = new TimeSeries((Comparable)((Object)seriesDefn.seriesName));
                seriesDefn.dataFn.all(data).forEach(t -> series.add((RegularTimePeriod)t.t1, (Number)t.t2));
                return series;
            }).forEach(arg_0 -> ((TimeSeriesCollection)result).addSeries(arg_0));
            return result;
        };
    }
}

