/*
 * Decompiled with CFR 0.152.
 */
package org.hcl.pdftemplate.freeChart;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.util.List;
import java.util.function.BiFunction;
import org.hcl.pdftemplate.freeChart.ColorRange;
import org.hcl.pdftemplate.freeChart.SeriesDefn;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;

public class XYRendererVariableColor
extends XYLineAndShapeRenderer {
    final ColorRange colorRange;
    final XYDataset dataset;

    public static <Data, XData> BiFunction<List<SeriesDefn<Data, XData>>, XYDataset, XYLineAndShapeRenderer> create(ColorRange colorRange) {
        return (series, dataSet) -> new XYRendererVariableColor(colorRange, (XYDataset)dataSet);
    }

    public Paint getItemPaint(int row, int col) {
        Paint cpaint = this.getItemColor(row, col);
        if (cpaint == null) {
            cpaint = super.getItemPaint(row, col);
        }
        return cpaint;
    }

    public Color getItemColor(int row, int col) {
        double y = this.dataset.getYValue(row, col);
        return this.colorRange.getColor(y);
    }

    protected void drawFirstPassShape(Graphics2D g2, int pass, int series, int item, Shape shape) {
        g2.setStroke(this.getItemStroke(series, item));
        Color c1 = this.getItemColor(series, item);
        Color c2 = this.getItemColor(series, item - 1);
        GradientPaint linePaint = new GradientPaint(0.0f, 0.0f, c1, 0.0f, 300.0f, c2);
        g2.setPaint(linePaint);
        g2.draw(shape);
    }

    public XYRendererVariableColor(ColorRange colorRange, XYDataset dataset) {
        this.colorRange = colorRange;
        this.dataset = dataset;
    }
}

