/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.processors;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import one.xingyi.optics.annotations.Optics;
import one.xingyi.processors.FileDefn;
import one.xingyi.processors.RecordOpticsDetails;
import one.xingyi.processors.RecordOpticsWithTraversals;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;

@SupportedAnnotationTypes(value={"one.xingyi.optics.annotations.Optics"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_16)
public class Processor
extends AbstractProcessor {
    private Messager messager;
    private ProcessingEnvironment pEnv;
    private Filer filer;
    private STGroupFile stringTemplate;

    protected void log(String message) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, message);
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
        this.pEnv = processingEnv;
        this.filer = this.pEnv.getFiler();
        this.log("Init  Optics annotations");
        this.stringTemplate = new STGroupFile("record.stg");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.log("Processing Optics annotations" + annotations.size());
        Iterator<? extends TypeElement> iterator = annotations.iterator();
        if (iterator.hasNext()) {
            TypeElement annotation = iterator.next();
            this.log("Processing Optics annotation " + annotation);
            if (annotation.getQualifiedName().toString().equals(Optics.class.getName())) {
                this.processOpticsAnnotation(roundEnv, annotation);
            }
            return true;
        }
        return false;
    }

    public String opticsClassName(RecordOpticsWithTraversals details) {
        return details.getPackageName() + "." + details.getClassName() + "Optics";
    }

    Stream<RecordOpticsDetails> fromAnnotation(RoundEnvironment roundEnv, TypeElement annotation) {
        annotation.getTypeParameters().forEach(t -> this.log("Type parameter " + t));
        return roundEnv.getElementsAnnotatedWith(annotation).stream().map(RecordOpticsDetails.fromElement(this::log));
    }

    private void processOpticsAnnotation(RoundEnvironment roundEnv, TypeElement annotation) {
        List<RecordOpticsDetails> recordOpticsDetails = this.fromAnnotation(roundEnv, annotation).toList();
        recordOpticsDetails.stream().map(rod -> {
            if (rod.isDebug()) {
                this.log("Processing " + rod);
            }
            RecordOpticsWithTraversals withTraversals = RecordOpticsWithTraversals.from(recordOpticsDetails, rod, this::log);
            if (rod.isDebug()) {
                this.log("  --  " + withTraversals);
            }
            return withTraversals;
        }).map(this::makeRecordOpticsFileDefn).forEach(this::makeSourceFile);
    }

    private FileDefn makeRecordOpticsFileDefn(RecordOpticsWithTraversals d) {
        String rendered = this.render(d, "recordOptic");
        String className = this.opticsClassName(d);
        return new FileDefn(className, rendered);
    }

    private void makeSourceFile(FileDefn fileDefn) {
        try {
            JavaFileObject builderFile = this.filer.createSourceFile(fileDefn.className(), new Element[0]);
            try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
                out.println(fileDefn.content());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    String render(RecordOpticsWithTraversals details, String templateName) {
        List allRecordsAndFields = details.getTraversalDetails().stream().flatMap(td -> td.getPath().stream()).distinct().toList();
        ST record = this.stringTemplate.getInstanceOf(templateName);
        record.add("details", (Object)details);
        record.add("allRecordsAndFields", allRecordsAndFields);
        return record.render();
    }
}

