/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.processors;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import one.xingyi.processors.RecordOpticsDetails;
import one.xingyi.processors.Utils;
import one.xingyi.processors.ViewFieldDetails;

class RecordAndField {
    final RecordOpticsDetails record;
    final ViewFieldDetails field;
    final String pathPart;

    static List<RecordAndField> fromPath(List<RecordOpticsDetails> allDetails, RecordOpticsDetails details, List<String> path, int index, Consumer<String> log) {
        Optional<RecordOpticsDetails> newDetails;
        if (index >= path.size()) {
            return List.of();
        }
        Optional<ViewFieldDetails> foundField = details.find(path.get(index));
        if (details.isDebug()) {
            log.accept("fromPath: " + details.getClassName() + " " + path + " " + index + " " + foundField);
        }
        if (foundField.isEmpty()) {
            return List.of();
        }
        ViewFieldDetails fieldDetails = foundField.get();
        RecordAndField recordAndField = new RecordAndField(details, fieldDetails, path.get(index));
        if (index == path.size() - 1) {
            return List.of(recordAndField);
        }
        if (details.isDebug()) {
            log.accept("   allDetails: " + allDetails.stream().map(RecordOpticsDetails::getCanonicalName));
            log.accept("   looking for " + fieldDetails.containedFieldType.getString());
        }
        if ((newDetails = allDetails.stream().filter(d -> d.getCanonicalName().equals(fieldDetails.containedFieldType.getString())).findFirst()).isEmpty()) {
            return List.of(recordAndField);
        }
        List<RecordAndField> restOfList = RecordAndField.fromPath(allDetails, newDetails.get(), path, index + 1, log);
        return Utils.insert(restOfList, recordAndField);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecordAndField)) {
            return false;
        }
        RecordAndField other = (RecordAndField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RecordOpticsDetails this$record = this.getRecord();
        RecordOpticsDetails other$record = other.getRecord();
        if (this$record == null ? other$record != null : !((Object)this$record).equals(other$record)) {
            return false;
        }
        ViewFieldDetails this$field = this.getField();
        ViewFieldDetails other$field = other.getField();
        if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
            return false;
        }
        String this$pathPart = this.getPathPart();
        String other$pathPart = other.getPathPart();
        return !(this$pathPart == null ? other$pathPart != null : !this$pathPart.equals(other$pathPart));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecordAndField;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RecordOpticsDetails $record = this.getRecord();
        result = result * 59 + ($record == null ? 43 : ((Object)$record).hashCode());
        ViewFieldDetails $field = this.getField();
        result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
        String $pathPart = this.getPathPart();
        result = result * 59 + ($pathPart == null ? 43 : $pathPart.hashCode());
        return result;
    }

    public RecordOpticsDetails getRecord() {
        return this.record;
    }

    public ViewFieldDetails getField() {
        return this.field;
    }

    public String getPathPart() {
        return this.pathPart;
    }

    public String toString() {
        return "RecordAndField(record=" + this.getRecord() + ", field=" + this.getField() + ", pathPart=" + this.getPathPart() + ")";
    }

    public RecordAndField(RecordOpticsDetails record, ViewFieldDetails field, String pathPart) {
        this.record = record;
        this.field = field;
        this.pathPart = pathPart;
    }
}

