/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.optics.annotations.processors;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import one.xingyi.optics.annotations.processors.PackageAndClass;
import one.xingyi.optics.annotations.processors.RecordOpticsDetails;
import one.xingyi.optics.annotations.processors.RecordedTraversals;
import one.xingyi.optics.annotations.processors.TraversalWithFullDetails;
import one.xingyi.optics.annotations.processors.Utils;
import one.xingyi.optics.annotations.processors.ViewFieldDetails;
import one.xingyi.optics.annotations.processors.WithDebug;
import one.xingyi.optics.annotations.serialise.IAnnotationProcessorLoader;

public class RecordOpticsWithTraversals {
    private final String packageName;
    private final String className;
    private final boolean addListTraversal;
    private final List<ViewFieldDetails> fieldDetails;
    private final List<TraversalWithFullDetails> traversalDetails;
    private final boolean debug;

    public static RecordOpticsWithTraversals from(IAnnotationProcessorLoader<WithDebug<PackageAndClass>, RecordedTraversals> store, RecordOpticsDetails details, Consumer<String> log) throws IOException {
        List<TraversalWithFullDetails> tds = Utils.map(details.getTraversalDetails(), td -> TraversalWithFullDetails.from(details, td, store, log));
        return new RecordOpticsWithTraversals(details.getPackageName(), details.getClassName(), details.isAddListTraversal(), details.getFieldDetails(), tds, details.isDebug());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecordOpticsWithTraversals)) {
            return false;
        }
        RecordOpticsWithTraversals other = (RecordOpticsWithTraversals)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAddListTraversal() != other.isAddListTraversal()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        List<ViewFieldDetails> this$fieldDetails = this.getFieldDetails();
        List<ViewFieldDetails> other$fieldDetails = other.getFieldDetails();
        if (this$fieldDetails == null ? other$fieldDetails != null : !((Object)this$fieldDetails).equals(other$fieldDetails)) {
            return false;
        }
        List<TraversalWithFullDetails> this$traversalDetails = this.getTraversalDetails();
        List<TraversalWithFullDetails> other$traversalDetails = other.getTraversalDetails();
        return !(this$traversalDetails == null ? other$traversalDetails != null : !((Object)this$traversalDetails).equals(other$traversalDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecordOpticsWithTraversals;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAddListTraversal() ? 79 : 97);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        List<ViewFieldDetails> $fieldDetails = this.getFieldDetails();
        result = result * 59 + ($fieldDetails == null ? 43 : ((Object)$fieldDetails).hashCode());
        List<TraversalWithFullDetails> $traversalDetails = this.getTraversalDetails();
        result = result * 59 + ($traversalDetails == null ? 43 : ((Object)$traversalDetails).hashCode());
        return result;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isAddListTraversal() {
        return this.addListTraversal;
    }

    public List<ViewFieldDetails> getFieldDetails() {
        return this.fieldDetails;
    }

    public List<TraversalWithFullDetails> getTraversalDetails() {
        return this.traversalDetails;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String toString() {
        return "RecordOpticsWithTraversals(packageName=" + this.getPackageName() + ", className=" + this.getClassName() + ", addListTraversal=" + this.isAddListTraversal() + ", fieldDetails=" + this.getFieldDetails() + ", traversalDetails=" + this.getTraversalDetails() + ", debug=" + this.isDebug() + ")";
    }

    public RecordOpticsWithTraversals(String packageName, String className, boolean addListTraversal, List<ViewFieldDetails> fieldDetails, List<TraversalWithFullDetails> traversalDetails, boolean debug) {
        this.packageName = packageName;
        this.className = className;
        this.addListTraversal = addListTraversal;
        this.fieldDetails = fieldDetails;
        this.traversalDetails = traversalDetails;
        this.debug = debug;
    }
}

