/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.optics.annotations.processors;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.xingyi.optics.annotations.processors.NameAndType;
import one.xingyi.optics.annotations.processors.PackageAndClass;
import one.xingyi.optics.annotations.processors.Utils;
import one.xingyi.optics.annotations.processors.WithDebug;

public record RecordedTraversals(boolean debug, List<NameAndType> classAndFields) {
    static BiFunction<WithDebug<PackageAndClass>, String, RecordedTraversals> parse = (from, s) -> {
        String[] lines = s.split("\n");
        List<NameAndType> namesAndTypes = Arrays.stream(lines).map(String::trim).filter(s1 -> !s1.isEmpty()).flatMap(line -> {
            String name = Utils.firstPart(line, ":", null);
            String packageAndClass = Utils.lastPart(line, ":", null);
            if (name == null || packageAndClass == null) {
                return Stream.empty();
            }
            return Stream.of(new NameAndType(name, PackageAndClass.from(packageAndClass)));
        }).toList();
        return new RecordedTraversals(from.debug(), namesAndTypes);
    };
    static Function<RecordedTraversals, String> printer = s -> s.classAndFields.stream().map(NameAndType::getString).collect(Collectors.joining("\n"));
}

