/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.optics.annotations.processors;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import one.xingyi.optics.annotations.processors.ClassOpticsDetails;
import one.xingyi.optics.annotations.processors.NameAndType;
import one.xingyi.optics.annotations.processors.PackageAndClass;
import one.xingyi.optics.annotations.processors.RecordedTraversals;
import one.xingyi.optics.annotations.processors.TraversalDetails;
import one.xingyi.optics.annotations.processors.TraversalPathPart;
import one.xingyi.optics.annotations.processors.Utils;
import one.xingyi.optics.annotations.processors.ViewFieldDetails;
import one.xingyi.optics.annotations.processors.WithDebug;
import one.xingyi.optics.annotations.serialise.IAnnotationProcessorLoader;

class TraversalWithFullDetails {
    protected final String name;
    protected final List<TraversalPathPart> path;

    public PackageAndClass getClassAtEnd() {
        return this.path.get((int)(this.path.size() - 1)).field.getFieldType();
    }

    static TraversalWithFullDetails from(ClassOpticsDetails recordDetails, TraversalDetails details, IAnnotationProcessorLoader<WithDebug<PackageAndClass>, RecordedTraversals> store, Consumer<String> log) throws IOException {
        boolean debug = recordDetails.isDebug();
        List<String> path = details.path();
        if (path.size() == 0) {
            throw new RuntimeException("No traversals for " + recordDetails.getClassName());
        }
        String first = path.get(0);
        List<String> rest = path.subList(1, path.size());
        Optional<ViewFieldDetails> firstField = recordDetails.getFieldDetails().stream().filter(fd -> fd.name.equals(first)).findFirst();
        if (firstField.isEmpty()) {
            throw new RuntimeException("Could not find field" + first + " in the class " + recordDetails.getCanonicalName());
        }
        TraversalPathPart firstPart = new TraversalPathPart(recordDetails.getPackageAndClass(), new NameAndType(firstField.get().name, firstField.get().containedFieldType));
        List tds = Utils.foldLeft(rest, List.of(firstPart), (acc, v) -> {
            Optional<NameAndType> found;
            TraversalPathPart last = (TraversalPathPart)acc.get(acc.size() - 1);
            PackageAndClass lastFieldType = last.field.getFieldType();
            RecordedTraversals loaded = (RecordedTraversals)store.load(WithDebug.of(lastFieldType, recordDetails.isDebug()));
            if (debug) {
                log.accept("Loaded for path (" + v + ") => " + loaded);
            }
            if ((found = loaded.classAndFields().stream().filter(nat -> nat.getFieldName().equals(v)).findFirst()).isEmpty()) {
                throw new RuntimeException("Could not find " + v + " in " + lastFieldType + " for " + recordDetails.getClassName() + ":" + path);
            }
            return Utils.append(acc, new TraversalPathPart(lastFieldType, found.get()));
        });
        return new TraversalWithFullDetails(details.name(), tds);
    }

    public String toString() {
        return "TraversalWithFullDetails(" + this.name + ", " + this.path.stream().map(TraversalPathPart::toString).collect(Collectors.joining(",")) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TraversalWithFullDetails)) {
            return false;
        }
        TraversalWithFullDetails other = (TraversalWithFullDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<TraversalPathPart> this$path = this.getPath();
        List<TraversalPathPart> other$path = other.getPath();
        return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TraversalWithFullDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<TraversalPathPart> $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    public List<TraversalPathPart> getPath() {
        return this.path;
    }

    public TraversalWithFullDetails(String name, List<TraversalPathPart> path) {
        this.name = name;
        this.path = path;
    }
}

