/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.optics.annotations.processors;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import one.xingyi.optics.annotations.Optics;
import one.xingyi.optics.annotations.processors.ClassOpticsDetails;
import one.xingyi.optics.annotations.processors.ClassOpticsWithTraversals;
import one.xingyi.optics.annotations.processors.FileDefn;
import one.xingyi.optics.annotations.processors.NameAndType;
import one.xingyi.optics.annotations.processors.PackageAndClass;
import one.xingyi.optics.annotations.processors.RecordedTraversals;
import one.xingyi.optics.annotations.processors.Utils;
import one.xingyi.optics.annotations.processors.WithDebug;
import one.xingyi.optics.annotations.serialise.IAnnotationProcessorStore;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;

@SupportedAnnotationTypes(value={"one.xingyi.optics.annotations.Optics"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
public class Processor
extends AbstractProcessor {
    private Messager messager;
    private ProcessingEnvironment pEnv;
    private Filer filer;
    private STGroupFile stringTemplate;
    protected IAnnotationProcessorStore<WithDebug<PackageAndClass>, RecordedTraversals> store;

    protected void log(String message) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, message);
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
        this.pEnv = processingEnv;
        this.filer = this.pEnv.getFiler();
        this.log("Init  Optics annotations");
        this.stringTemplate = new STGroupFile("record.stg");
        this.store = IAnnotationProcessorStore.defaultStore(this.filer, WithDebug::getT, "optics", RecordedTraversals.parse, RecordedTraversals.printer, this::log, WithDebug::isDebug);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.log("Processing Optics annotations" + annotations.size());
        Iterator<? extends TypeElement> iterator = annotations.iterator();
        if (iterator.hasNext()) {
            TypeElement annotation = iterator.next();
            if (annotation.getQualifiedName().toString().equals(Optics.class.getName())) {
                try {
                    this.log("Processing Optics annotation " + annotation);
                    this.processOpticsAnnotation(roundEnv, annotation);
                }
                catch (IOException e) {
                    this.log("Error processing Optics annotation " + annotation + " " + e.getClass() + "/" + e.getMessage());
                }
            }
            return true;
        }
        return false;
    }

    public PackageAndClass opticsClassName(ClassOpticsWithTraversals details) {
        return new PackageAndClass(null, details.getPackageName(), details.getClassName() + "Optics");
    }

    Stream<ClassOpticsDetails> fromAnnotation(RoundEnvironment roundEnv, TypeElement annotation) {
        annotation.getTypeParameters().forEach(t -> this.log("Type parameter " + t));
        return roundEnv.getElementsAnnotatedWith(annotation).stream().map(ClassOpticsDetails.makeDetailFromElement(this::log));
    }

    private void processOpticsAnnotation(RoundEnvironment roundEnv, TypeElement annotation) throws IOException {
        List classOpticsDetails = this.fromAnnotation(roundEnv, annotation).collect(Collectors.toList());
        for (ClassOpticsDetails rop : classOpticsDetails) {
            RecordedTraversals recorded = new RecordedTraversals(rop.isDebug(), rop.getFieldDetails().stream().filter(f -> f.containedFieldType != null).map(f -> new NameAndType(f.name, f.getContainedFieldType())).collect(Collectors.toList()));
            this.store.store(WithDebug.of(rop.getPackageAndClass(), rop.isDebug()), recorded);
        }
        List<ClassOpticsWithTraversals> traversals = Utils.map(classOpticsDetails, rod -> {
            if (rod.isDebug()) {
                this.log("Processing " + rod);
            }
            ClassOpticsWithTraversals withTraversals = ClassOpticsWithTraversals.from(this.store, rod, this::log);
            if (rod.isDebug()) {
                this.log("  --  " + withTraversals);
            }
            return withTraversals;
        });
        Utils.map(traversals, this::makeClassOpticsFileDefn).forEach(this::makeSourceFile);
    }

    private FileDefn makeClassOpticsFileDefn(ClassOpticsWithTraversals d) {
        String rendered = this.render(d, "recordOptic");
        PackageAndClass className = this.opticsClassName(d);
        return new FileDefn(className, rendered);
    }

    private void makeSourceFile(FileDefn fileDefn) {
        try {
            String sourceFile = fileDefn.clazz.getString();
            JavaFileObject builderFile = this.filer.createSourceFile(sourceFile, new Element[0]);
            try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
                out.println(fileDefn.content);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void makeRecordFile(FileDefn fileDefn) {
        try {
            FileObject builderFile = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, fileDefn.clazz.getPackageName(), fileDefn.clazz.getClassName(), new Element[0]);
            try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
                out.println(fileDefn.content);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    String render(ClassOpticsWithTraversals details, String templateName) {
        ST record = this.stringTemplate.getInstanceOf(templateName);
        record.add("details", (Object)details);
        return record.render();
    }
}

