/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.optics.annotations.serialise;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import one.xingyi.optics.annotations.processors.PackageAndClass;
import one.xingyi.optics.annotations.serialise.IAnnotationProcessorStorer;

class CachedAnnotationProcessorStorer<From, To>
implements IAnnotationProcessorStorer<From, To> {
    private final IAnnotationProcessorStorer<From, To> storer;
    private final ConcurrentHashMap<PackageAndClass, To> cache;
    private final Function<From, PackageAndClass> fromToClassName;

    @Override
    public void store(From from, To to) throws IOException {
        PackageAndClass className = this.fromToClassName.apply(from);
        this.cache.put(className, to);
        this.storer.store(from, to);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CachedAnnotationProcessorStorer)) {
            return false;
        }
        CachedAnnotationProcessorStorer other = (CachedAnnotationProcessorStorer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IAnnotationProcessorStorer<From, To> this$storer = this.getStorer();
        IAnnotationProcessorStorer<From, To> other$storer = other.getStorer();
        if (this$storer == null ? other$storer != null : !this$storer.equals(other$storer)) {
            return false;
        }
        ConcurrentHashMap<PackageAndClass, To> this$cache = this.getCache();
        ConcurrentHashMap<PackageAndClass, To> other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache)) {
            return false;
        }
        Function<From, PackageAndClass> this$fromToClassName = this.getFromToClassName();
        Function<From, PackageAndClass> other$fromToClassName = other.getFromToClassName();
        return !(this$fromToClassName == null ? other$fromToClassName != null : !this$fromToClassName.equals(other$fromToClassName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CachedAnnotationProcessorStorer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IAnnotationProcessorStorer<From, To> $storer = this.getStorer();
        result = result * 59 + ($storer == null ? 43 : $storer.hashCode());
        ConcurrentHashMap<PackageAndClass, To> $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        Function<From, PackageAndClass> $fromToClassName = this.getFromToClassName();
        result = result * 59 + ($fromToClassName == null ? 43 : $fromToClassName.hashCode());
        return result;
    }

    public IAnnotationProcessorStorer<From, To> getStorer() {
        return this.storer;
    }

    public ConcurrentHashMap<PackageAndClass, To> getCache() {
        return this.cache;
    }

    public Function<From, PackageAndClass> getFromToClassName() {
        return this.fromToClassName;
    }

    public String toString() {
        return "CachedAnnotationProcessorStorer(storer=" + this.getStorer() + ", cache=" + this.getCache() + ", fromToClassName=" + this.getFromToClassName() + ")";
    }

    public CachedAnnotationProcessorStorer(IAnnotationProcessorStorer<From, To> storer, ConcurrentHashMap<PackageAndClass, To> cache, Function<From, PackageAndClass> fromToClassName) {
        this.storer = storer;
        this.cache = cache;
        this.fromToClassName = fromToClassName;
    }
}

