/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.optics.annotations.serialise;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.xingyi.optics.annotations.serialise.IAnnotationProcessorLoader;

class DebuggingAnnotationProcessorLoader<From, T>
implements IAnnotationProcessorLoader<From, T> {
    private final IAnnotationProcessorLoader<From, T> loader;
    private final Predicate<From> debugPredicate;
    private final Consumer<String> logger;

    @Override
    public T load(From from) throws IOException {
        try {
            if (this.debugPredicate.test(from)) {
                this.logger.accept("Loading " + from);
            }
            T result = this.loader.load(from);
            if (this.debugPredicate.test(from)) {
                this.logger.accept("Loaded " + result + " from " + from);
            }
            return result;
        }
        catch (IOException | RuntimeException e) {
            this.logger.accept("Error loading " + from + " " + e.getMessage());
            throw e;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebuggingAnnotationProcessorLoader)) {
            return false;
        }
        DebuggingAnnotationProcessorLoader other = (DebuggingAnnotationProcessorLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IAnnotationProcessorLoader<From, T> this$loader = this.getLoader();
        IAnnotationProcessorLoader<From, T> other$loader = other.getLoader();
        if (this$loader == null ? other$loader != null : !this$loader.equals(other$loader)) {
            return false;
        }
        Predicate<From> this$debugPredicate = this.getDebugPredicate();
        Predicate<From> other$debugPredicate = other.getDebugPredicate();
        if (this$debugPredicate == null ? other$debugPredicate != null : !this$debugPredicate.equals(other$debugPredicate)) {
            return false;
        }
        Consumer<String> this$logger = this.getLogger();
        Consumer<String> other$logger = other.getLogger();
        return !(this$logger == null ? other$logger != null : !this$logger.equals(other$logger));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DebuggingAnnotationProcessorLoader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IAnnotationProcessorLoader<From, T> $loader = this.getLoader();
        result = result * 59 + ($loader == null ? 43 : $loader.hashCode());
        Predicate<From> $debugPredicate = this.getDebugPredicate();
        result = result * 59 + ($debugPredicate == null ? 43 : $debugPredicate.hashCode());
        Consumer<String> $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        return result;
    }

    public IAnnotationProcessorLoader<From, T> getLoader() {
        return this.loader;
    }

    public Predicate<From> getDebugPredicate() {
        return this.debugPredicate;
    }

    public Consumer<String> getLogger() {
        return this.logger;
    }

    public String toString() {
        return "DebuggingAnnotationProcessorLoader(loader=" + this.getLoader() + ", debugPredicate=" + this.getDebugPredicate() + ", logger=" + this.getLogger() + ")";
    }

    public DebuggingAnnotationProcessorLoader(IAnnotationProcessorLoader<From, T> loader, Predicate<From> debugPredicate, Consumer<String> logger) {
        this.loader = loader;
        this.debugPredicate = debugPredicate;
        this.logger = logger;
    }
}

