package one.xingyi.profile;

import one.xingyi.helpers.MapHelpers;
import one.xingyi.interfaces.SupplierWithExceptionE;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

class ProfileImpl implements IProfile {
    private final ConcurrentHashMap<String, ProfileBuckets<ProfileBucket>> map;
    public ProfileImpl(ConcurrentHashMap<String, ProfileBuckets<ProfileBucket>> map) {this.map = map;}
    @Override
    public <T, E extends Exception> T profileE(String name, SupplierWithExceptionE<T, E> fn) throws E {
        long start = System.nanoTime();
        try {
            return fn.get();
        } finally {
            add(name, System.nanoTime() - start);
        }
    }
    @Override
    public <T> T profile(String name, Supplier<T> fn) {
        long start = System.nanoTime();
        try {
            return fn.get();
        } finally {
            add(name, System.nanoTime() - start);
        }
    }
    @Override
    public void add(String name, long duration) {
        boolean isIn = map.contains(name);
        ProfileBuckets<ProfileBucket> bucket = map.getOrDefault(name, ProfileBuckets.create());
        ProfileBuckets.add(bucket, duration);
        if (!isIn) map.put(name, bucket);
    }

    @Override
    public Map<String, ProfileBuckets<Long>> getMs() {
        return MapHelpers.map(map, (k, v) -> v.map(b -> b.avg() / 1000000));
    }
    @Override
    public Map<String, ProfileBuckets<Integer>> getCounts() {
        return MapHelpers.map(map, (k, v) -> v.map(b -> b.count.get()));
    }
    @Override
    public Map<String, Integer> getTotalCounts() {
        return MapHelpers.map(getCounts(), (k, v) -> v.addUp(Integer::sum));
    }
    @Override
    public Map<String, Long> getTotalAvg() {
        return MapHelpers.map(getMs(), (k, v) -> v.addUp(Long::sum));
    }
}
