/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.profile;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import one.xingyi.helpers.MapHelpers;
import one.xingyi.interfaces.SupplierWithExceptionE;
import one.xingyi.profile.IProfile;
import one.xingyi.profile.ProfileBucket;
import one.xingyi.profile.ProfileBuckets;

class ProfileImpl
implements IProfile {
    private final ConcurrentHashMap<String, ProfileBuckets<ProfileBucket>> map;

    public ProfileImpl(ConcurrentHashMap<String, ProfileBuckets<ProfileBucket>> map) {
        this.map = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T profileE(String name, SupplierWithExceptionE<T, E> fn) throws E {
        long start = System.nanoTime();
        try {
            Object object = fn.get();
            return (T)object;
        }
        finally {
            this.add(name, System.nanoTime() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T profile(String name, Supplier<T> fn) {
        long start = System.nanoTime();
        try {
            T t = fn.get();
            return t;
        }
        finally {
            this.add(name, System.nanoTime() - start);
        }
    }

    @Override
    public void add(String name, long duration) {
        boolean isIn = this.map.contains(name);
        ProfileBuckets<ProfileBucket> bucket = this.map.getOrDefault(name, ProfileBuckets.create());
        ProfileBuckets.add(bucket, duration);
        if (!isIn) {
            this.map.put(name, bucket);
        }
    }

    @Override
    public Map<String, ProfileBuckets<Long>> getMs() {
        return MapHelpers.map(this.map, (k, v) -> v.map(b -> b.avg() / 1000000L));
    }

    @Override
    public Map<String, ProfileBuckets<Integer>> getCounts() {
        return MapHelpers.map(this.map, (k, v) -> v.map(b -> b.count.get()));
    }

    @Override
    public Map<String, Integer> getTotalCounts() {
        return MapHelpers.map(this.getCounts(), (k, v) -> (Integer)v.addUp(Integer::sum));
    }

    @Override
    public Map<String, Long> getTotalAvg() {
        return MapHelpers.map(this.getMs(), (k, v) -> (Long)v.addUp(Long::sum));
    }
}

