/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.profile;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import one.xingyi.helpers.MapHelpers;
import one.xingyi.interfaces.INanoTime;
import one.xingyi.interfaces.RunnableWithExceptionE;
import one.xingyi.interfaces.SupplierWithExceptionE;
import one.xingyi.profile.IProfile;
import one.xingyi.profile.ProfileBucket;
import one.xingyi.profile.ProfileBuckets;

class ProfileImpl
implements IProfile {
    private final ConcurrentHashMap<String, ProfileBuckets<ProfileBucket>> map;
    private final String prefix;
    final INanoTime nanoTime;

    public ProfileImpl(String prefix, ConcurrentHashMap<String, ProfileBuckets<ProfileBucket>> map, INanoTime nanoTime) {
        this.prefix = prefix;
        this.map = map;
        this.nanoTime = nanoTime;
    }

    @Override
    public IProfile withPrefix(String prefix) {
        return new ProfileImpl(this.prefix + prefix + ".", this.map, this.nanoTime);
    }

    @Override
    public String print() {
        int nanosToMs = 1000000;
        return MapHelpers.print(this.map, (k, v) -> "{count: " + v.mapAndAdd(pb -> pb.count.get(), Integer::sum) + ", time: " + v.mapAndAdd(pb -> pb.total.get(), Long::sum) / (long)nanosToMs + ", avg: " + v.mapAndAdd(ProfileBucket::avg, Long::sum) / (long)nanosToMs + ", <10ms:" + v.lessThan10ms + ", <100ms:" + v.lessThan100ms + ", <1s:" + v.lessThan1s + ", <10s:" + v.lessThan10s + ", rest:" + v.rest + '}');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T profileE(String name, SupplierWithExceptionE<T, E> fn) throws E {
        long start = this.nanoTime.nanoTime();
        try {
            Object object = fn.get();
            return (T)object;
        }
        finally {
            this.add(name, this.nanoTime.nanoTime() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T profile(String name, Supplier<T> fn) {
        long start = this.nanoTime.nanoTime();
        try {
            T t = fn.get();
            return t;
        }
        finally {
            this.add(name, this.nanoTime.nanoTime() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(String name, Runnable fn) {
        long start = this.nanoTime.nanoTime();
        try {
            fn.run();
        }
        finally {
            this.add(name, this.nanoTime.nanoTime() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Exception> void runE(String name, RunnableWithExceptionE<E> fn) throws E {
        long start = this.nanoTime.nanoTime();
        try {
            fn.run();
        }
        finally {
            this.add(name, this.nanoTime.nanoTime() - start);
        }
    }

    @Override
    public void add(String name, long duration) {
        String fullName = this.prefix + name;
        boolean isIn = this.map.contains(fullName);
        ProfileBuckets<ProfileBucket> bucket = this.map.getOrDefault(fullName, ProfileBuckets.create());
        ProfileBuckets.add(bucket, duration);
        if (!isIn) {
            this.map.put(fullName, bucket);
        }
    }

    @Override
    public Map<String, ProfileBuckets<Long>> getMs() {
        return MapHelpers.map(this.map, (k, v) -> v.map(b -> b.avg() / 1000000L));
    }

    @Override
    public Map<String, ProfileBuckets<Integer>> getCounts() {
        return MapHelpers.map(this.map, (k, v) -> v.map(b -> b.count.get()));
    }

    @Override
    public Map<String, Integer> getTotalCounts() {
        return MapHelpers.map(this.getCounts(), (k, v) -> (Integer)v.add(Integer::sum));
    }

    @Override
    public Map<String, Long> getTotalAvg() {
        return MapHelpers.map(this.getMs(), (k, v) -> (Long)v.add(Long::sum));
    }
}

