/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.profile;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import one.xingyi.helpers.ListHelpers;
import one.xingyi.interfaces.INanoTime;
import one.xingyi.profile.IProfile;
import one.xingyi.profile.ProfilingMBean;

public class Profiling
implements ProfilingMBean {
    final IProfile profile;
    static final List<Profiling> allProfiling = new ArrayList<Profiling>();
    private INanoTime nanoTime;
    final String packageName;

    public static String printAll() {
        return String.join((CharSequence)"\n", ListHelpers.map(allProfiling, p -> p.profile.print()));
    }

    public Profiling(INanoTime nanoTime, String packageName) {
        this.nanoTime = nanoTime;
        this.packageName = packageName;
        this.profile = IProfile.makeProfileMap(nanoTime).withPrefix(packageName);
        allProfiling.add(this);
    }

    public IProfile registerWithPrefix(String prefix) {
        Profiling mBean = new Profiling(this.nanoTime, this.packageName + "." + prefix);
        mBean.register();
        return mBean.profile;
    }

    @Override
    public String getProfiles() {
        return this.profile.print();
    }

    @Override
    public void clear() {
        this.profile.clear();
    }

    public void register() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName(this.packageName + ":type=Profile");
            mbs.registerMBean(this, name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws MalformedObjectNameException, NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException, InterruptedException {
        Profiling mBean = new Profiling(INanoTime.realNanoTime, "one.xingyi");
        IProfile p1 = mBean.registerWithPrefix("one");
        IProfile p2 = mBean.registerWithPrefix("two");
        while (true) {
            Thread.sleep(1000L);
            p1.add("test11", 100L);
            p1.add("test12", 100L);
            p2.add("test21", 100L);
            p2.add("test22", 100L);
        }
    }
}

