/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.profile;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import one.xingyi.helpers.StringHelper;
import one.xingyi.profile.IProfileBucket;

public class ProfileBucket
implements IProfileBucket {
    final AtomicInteger count = new AtomicInteger();
    final AtomicLong total = new AtomicLong();
    long snapshot = 0L;

    @Override
    public void add(long time) {
        this.snapshot = time;
        this.count.incrementAndGet();
        this.total.addAndGet(time);
    }

    @Override
    public int getCount() {
        return this.count.get();
    }

    @Override
    public long getTotal() {
        return this.total.get();
    }

    @Override
    public long getSnapshot() {
        return this.snapshot;
    }

    public String toString() {
        int nanosToMs = 1000000;
        int c = this.count.get();
        long totalL = this.total.get() / (long)nanosToMs;
        return StringHelper.toJsonObject((Object[])new Object[]{"count", c, "total", totalL, "avg", this.avg() / (long)nanosToMs, "snapshot", this.snapshot / (long)nanosToMs});
    }
}

