/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.profile;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import one.xingyi.helpers.MapHelpers;
import one.xingyi.helpers.StringHelper;
import one.xingyi.interfaces.INanoTime;
import one.xingyi.interfaces.RunnableWithExceptionE;
import one.xingyi.interfaces.SupplierWithExceptionE;
import one.xingyi.profile.IProfile;
import one.xingyi.profile.IProfileBuilder;
import one.xingyi.profile.IProfileControl;
import one.xingyi.profile.IProfileDetailedInfo;
import one.xingyi.profile.IProfileInfo;
import one.xingyi.profile.ProfileBucket;
import one.xingyi.profile.ProfileBuckets;

class ProfileImpl
implements IProfile,
IProfileBuilder,
IProfileDetailedInfo,
IProfileControl {
    final ConcurrentHashMap<String, ProfileBuckets<ProfileBucket>> map;
    private final String prefix;
    final INanoTime nanoTime;
    long mainSnapshot = 0L;
    String main;

    public ProfileImpl(String prefix, ConcurrentHashMap<String, ProfileBuckets<ProfileBucket>> map, INanoTime nanoTime) {
        this.prefix = prefix;
        this.map = map;
        this.nanoTime = nanoTime;
    }

    @Override
    public IProfileBuilder main(String name) {
        this.main = name;
        return this;
    }

    @Override
    public IProfileBuilder withPrefix(String prefix) {
        return new ProfileImpl(this.prefix + prefix + ".", this.map, this.nanoTime);
    }

    static IProfileInfo fromProfileBuckets(final ProfileBuckets<ProfileBucket> bs, final long mainSnapshot) {
        return new IProfileInfo(){

            @Override
            public int getCount() {
                return bs.mapAndAdd(pb -> pb.count.get(), Integer::sum);
            }

            @Override
            public long getTotal() {
                return bs.mapAndAdd(pb -> pb.total.get(), Long::sum);
            }

            @Override
            public long getSnapshot() {
                return mainSnapshot;
            }
        };
    }

    @Override
    public IProfileInfo mainProfileInfo() {
        return ProfileImpl.fromProfileBuckets(this.getBucketAddingIfNeeded(this.prefix), this.mainSnapshot);
    }

    @Override
    public String print() {
        int nanosToMs = 1000000;
        return MapHelpers.jsonPrint((String)",\n", this.map, (k, v) -> {
            long time = v.mapAndAdd(pb -> pb.total.get(), Long::sum) / (long)nanosToMs;
            int count = v.mapAndAdd(pb -> pb.count.get(), Integer::sum);
            long avg = count == 0 ? 0L : time / (long)count;
            return StringHelper.toJsonObject((Object[])new Object[]{"count", count, "time", time, "avg", avg, "<10ms", v.lessThan10ms, "<100ms", v.lessThan100ms, "<1s", v.lessThan1s, "<10s", v.lessThan10s, "rest", v.rest});
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T profileE(String name, SupplierWithExceptionE<T, E> fn) throws E {
        long start = this.nanoTime.nanoTime();
        try {
            Object object = fn.get();
            return (T)object;
        }
        finally {
            this.add(name, this.nanoTime.nanoTime() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T profile(String name, Supplier<T> fn) {
        long start = this.nanoTime.nanoTime();
        try {
            T t = fn.get();
            return t;
        }
        finally {
            this.add(name, this.nanoTime.nanoTime() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(String name, Runnable fn) {
        long start = this.nanoTime.nanoTime();
        try {
            fn.run();
        }
        finally {
            this.add(name, this.nanoTime.nanoTime() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Exception> void runE(String name, RunnableWithExceptionE<E> fn) throws E {
        long start = this.nanoTime.nanoTime();
        try {
            fn.run();
        }
        finally {
            this.add(name, this.nanoTime.nanoTime() - start);
        }
    }

    @Override
    public void add(String name, long duration) {
        String fullName = this.prefix + name;
        if (name.equals(this.main)) {
            this.mainSnapshot = duration;
        }
        ProfileBuckets<ProfileBucket> bucket = this.getBucketAddingIfNeeded(fullName);
        ProfileBuckets.add(bucket, duration);
    }

    private ProfileBuckets<ProfileBucket> getBucketAddingIfNeeded(String fullName) {
        boolean isIn = this.map.containsKey(fullName);
        ProfileBuckets<ProfileBucket> bucket = this.map.getOrDefault(fullName, ProfileBuckets.create());
        if (!isIn) {
            this.map.put(fullName, bucket);
        }
        return bucket;
    }

    @Override
    public Map<String, ProfileBuckets<Long>> getMs() {
        return MapHelpers.map(this.map, (k, v) -> v.map(b -> b.avg() / 1000000L));
    }

    @Override
    public Map<String, ProfileBuckets<Integer>> getCounts() {
        return MapHelpers.map(this.map, (k, v) -> v.map(b -> b.count.get()));
    }

    @Override
    public Map<String, Integer> getTotalCounts() {
        return MapHelpers.map(this.getCounts(), (k, v) -> (Integer)v.add(Integer::sum));
    }

    @Override
    public Map<String, Long> getTotalAvg() {
        return MapHelpers.map(this.getMs(), (k, v) -> (Long)v.add(Long::sum));
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

