/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.profile;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import one.xingyi.helpers.ListHelpers;
import one.xingyi.interfaces.INanoTime;
import one.xingyi.profile.IProfile;
import one.xingyi.profile.IProfileBuilder;
import one.xingyi.profile.IProfileInfo;
import one.xingyi.profile.ProfileImpl;
import one.xingyi.profile.ProfilingMBean;

public class Profiling
implements ProfilingMBean {
    final ProfileImpl profile;
    static final List<Profiling> allProfiling = new ArrayList<Profiling>();
    private INanoTime nanoTime;
    final String packageName;

    public static String printAll() {
        return String.join((CharSequence)"\n", ListHelpers.map(allProfiling, p -> p.profile.print()));
    }

    public Profiling(INanoTime nanoTime, String packageName) {
        this.nanoTime = nanoTime;
        this.packageName = packageName;
        this.profile = (ProfileImpl)IProfile.makeProfileMap(nanoTime).withPrefix(packageName);
        allProfiling.add(this);
    }

    public IProfileBuilder registerWithPrefix(String prefix) {
        Profiling mBean = new Profiling(this.nanoTime, this.packageName);
        mBean.register(prefix);
        return mBean.profile;
    }

    public IProfileBuilder registerWithPrefixAndMain(String prefix, String main) {
        return this.registerWithPrefix(prefix).main(main);
    }

    @Override
    public String print() {
        return this.profile.print();
    }

    @Override
    public void clear() {
        this.profile.clear();
    }

    public void register(String name) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(this, new ObjectName(this.packageName + ":type=" + name));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws MalformedObjectNameException, NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException, InterruptedException {
        Profiling mBean = new Profiling(INanoTime.realNanoTime, "one.xingyi");
        IProfileBuilder p1 = mBean.registerWithPrefixAndMain("op", "test11");
        IProfileBuilder p2 = mBean.registerWithPrefixAndMain("two", "test21");
        while (true) {
            Thread.sleep(1000L);
            p1.add("test11", 100L);
            p1.add("test12", 100L);
            p2.add("test21", 100L);
            p2.add("test22", 100L);
        }
    }

    IProfileInfo mainProfileInfo() {
        return this.profile.mainProfileInfo();
    }

    @Override
    public int getCount() {
        return this.mainProfileInfo().getCount();
    }

    @Override
    public long getTotal() {
        return this.mainProfileInfo().getTotal();
    }

    @Override
    public long getSnapshot() {
        return this.mainProfileInfo().getSnapshot();
    }

    @Override
    public String getMain() {
        return this.profile.prefix + this.profile.main;
    }
}

