package one.xingyi.profile;

import one.xingyi.interfaces.INanoTime;
import one.xingyi.interfaces.RunnableWithExceptionE;
import one.xingyi.interfaces.SupplierWithExceptionE;
import one.xingyi.profile.pathmap.IPathMap;

public interface IProfile {
    static IProfile root(String jmxName, INanoTime nanoTime) {return new Profile(jmxName, nanoTime, IPathMap.make(ProfileBuckets::create));}
    <T, E extends Exception> T profile(SupplierWithExceptionE<T, E> fn) throws E;
    <E extends Exception> void run(RunnableWithExceptionE<E> fn) throws E;
    IProfile child(String name);
    IProfile registerMBean();
}

