package one.xingyi.profile;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.ToString;

public interface IProfileInfo {
    int getCount();
    long getTotalMs();
    long getSnapshotMs();
    String getPath();

}

@RequiredArgsConstructor
@Getter
@ToString
@EqualsAndHashCode
class ProfileInfo implements IProfileInfo {
    final String path;
    final int count;
    final long totalMs;
    final long snapshotMs;

}
