/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.profile;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import one.xingyi.helpers.StringHelper;

public class ProfileBucket {
    final AtomicInteger count = new AtomicInteger();
    final AtomicLong total = new AtomicLong();
    long snapshot = 0L;

    static ProfileBucket simple() {
        return new ProfileBucket();
    }

    public void clear() {
        this.count.set(0);
        this.total.set(0L);
    }

    public void add(long time) {
        this.snapshot = time;
        this.count.incrementAndGet();
        this.total.addAndGet(time);
    }

    public int getCount() {
        return this.count.get();
    }

    public long getTotal() {
        return this.total.get();
    }

    public long getSnapshot() {
        return this.snapshot;
    }

    public String toString() {
        int nanosToMs = 1000000;
        int c = this.count.get();
        long totalL = this.total.get() / (long)nanosToMs;
        long avg = c == 0 ? 0L : totalL / (long)c;
        return StringHelper.toJsonObject((Object[])new Object[]{"count", c, "total", totalL, "avg", avg, "snapshot", this.snapshot / (long)nanosToMs});
    }
}

