/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.profile;

import one.xingyi.interfaces.INanoTime;
import one.xingyi.interfaces.RunnableWithExceptionE;
import one.xingyi.interfaces.SupplierWithExceptionE;
import one.xingyi.profile.Profile;
import one.xingyi.profile.ProfileBuckets;
import one.xingyi.profile.pathmap.IPathMap;

public interface IProfile {
    public static IProfile root(String jmxName, INanoTime nanoTime) {
        return new Profile(jmxName, nanoTime, IPathMap.make(ProfileBuckets::create));
    }

    public IProfile child(String var1);

    public <T, E extends Exception> T profile(SupplierWithExceptionE<T, E> var1) throws E;

    default public <T, E extends Exception> T profile(String name, SupplierWithExceptionE<T, E> fn) throws E {
        return this.child(name).profile(fn);
    }

    public <E extends Exception> void run(RunnableWithExceptionE<E> var1) throws E;

    default public <E extends Exception> void run(String name, RunnableWithExceptionE<E> fn) throws E {
        this.child(name).run(fn);
    }

    public IProfile registerMBean();

    public static String jsonFor(IProfile profile) {
        if (!(profile instanceof Profile)) {
            throw new RuntimeException("Not a Profile. Class is " + profile.getClass().getName());
        }
        Profile p = (Profile)profile;
        return p.json();
    }
}

