/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.profile;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import one.xingyi.helpers.MapHelpers;
import one.xingyi.interfaces.INanoTime;
import one.xingyi.interfaces.RunnableWithExceptionE;
import one.xingyi.interfaces.SupplierWithExceptionE;
import one.xingyi.profile.IProfile;
import one.xingyi.profile.IProfileInfo;
import one.xingyi.profile.ProfileBucket;
import one.xingyi.profile.ProfileBuckets;
import one.xingyi.profile.ProfileInfo;
import one.xingyi.profile.ProfileMBean;
import one.xingyi.profile.pathmap.IPathMap;

public class Profile
implements IProfile,
IProfileInfo,
ProfileMBean {
    final String jmxName;
    final INanoTime nanoTime;
    final IPathMap<ProfileBuckets<ProfileBucket>> map;
    static final int nanosToMs = 1000000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T profile(SupplierWithExceptionE<T, E> fn) throws E {
        long start = this.nanoTime.nanoTime();
        try {
            Object object = fn.get();
            return (T)object;
        }
        finally {
            long duration = this.nanoTime.nanoTime() - start;
            ProfileBuckets.add(this.map.get(), duration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Exception> void run(RunnableWithExceptionE<E> fn) throws E {
        long start = this.nanoTime.nanoTime();
        try {
            fn.run();
        }
        finally {
            long duration = this.nanoTime.nanoTime() - start;
            ProfileBuckets.add(this.map.get(), duration);
        }
    }

    @Override
    public IProfile child(String name) {
        return new Profile(this.jmxName, this.nanoTime, this.map.child(name));
    }

    @Override
    public IProfile registerMBean() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.registerMBean(this, new ObjectName(this.jmxName + ":type=Profile,name=" + this.map.path()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public int getCount() {
        return this.map.get().mapAndAdd(ProfileBucket::getCount, Integer::sum);
    }

    @Override
    public long getTotalMs() {
        return this.map.get().mapAndAdd(ProfileBucket::getTotal, Long::sum) / 1000000L;
    }

    @Override
    public String getPath() {
        return this.map.path();
    }

    @Override
    public long getSnapshotMs() {
        return this.map.get().snapshot();
    }

    public IProfileInfo info() {
        return new ProfileInfo(this.map.path(), this.getCount(), this.getTotalMs(), this.map.get().snapshot() / 1000000L);
    }

    @Override
    public String json() {
        HashMap map = new HashMap();
        this.map.fold(null, (acc, path, buckets) -> map.put(path, ProfileBuckets.json(buckets)));
        return MapHelpers.jsonPrint((String)"\n", map, (key, value) -> value);
    }

    @Override
    public void clear() {
        ProfileBuckets.clear(this.map.get());
    }

    public Profile(String jmxName, INanoTime nanoTime, IPathMap<ProfileBuckets<ProfileBucket>> map) {
        this.jmxName = jmxName;
        this.nanoTime = nanoTime;
        this.map = map;
    }
}

