/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.profile.pathmap;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import one.xingyi.helpers.MapHelpers;
import one.xingyi.interfaces.Function3;
import one.xingyi.profile.pathmap.IPathMap;

class PathMap<V>
implements IPathMap<V> {
    final String path;
    final Supplier<V> defaultValue;
    V value;
    final Map<String, IPathMap<V>> children = new ConcurrentHashMap<String, IPathMap<V>>();

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public void put(V value) {
        this.value = value;
    }

    @Override
    public V get() {
        return this.value;
    }

    @Override
    public IPathMap<V> child(String pathOffset) {
        return (IPathMap)MapHelpers.getOrAdd(this.children, (Object)pathOffset, () -> new PathMap<V>(this.path + (this.path.isEmpty() ? "" : ".") + pathOffset, this.defaultValue, this.defaultValue.get()));
    }

    @Override
    public Set<String> childPaths() {
        return this.children.keySet();
    }

    @Override
    public <Acc> Acc fold(Acc zero, Function3<Acc, String, V, Acc> foldFn) {
        Object acc = foldFn.apply(zero, (Object)this.path, this.value);
        TreeSet<String> keys = new TreeSet<String>(this.children.keySet());
        for (String key : keys) {
            acc = this.children.get(key).fold(acc, foldFn);
        }
        return (Acc)acc;
    }

    public PathMap(String path, Supplier<V> defaultValue, V value) {
        this.path = path;
        this.defaultValue = defaultValue;
        this.value = value;
    }
}

