/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.profile;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import one.xingyi.helpers.MapHelpers;
import one.xingyi.interfaces.INanoTime;
import one.xingyi.interfaces.RunnableWithExceptionE;
import one.xingyi.interfaces.SupplierWithExceptionE;
import one.xingyi.profile.IProfile;
import one.xingyi.profile.IProfileInfo;
import one.xingyi.profile.ProfileBucket;
import one.xingyi.profile.ProfileBuckets;
import one.xingyi.profile.ProfileInfo;
import one.xingyi.profile.ProfileMBean;
import one.xingyi.profile.pathmap.IPathMap;

public class Profile
implements IProfile,
IProfileInfo,
ProfileMBean {
    final String jmxName;
    final INanoTime nanoTime;
    final IPathMap<ProfileBuckets<ProfileBucket>> map;
    final Consumer<Exception> errorHandler;
    static final int nanosToMs = 1000000;

    @Override
    public <T, E extends Exception> T profile(SupplierWithExceptionE<T, E> fn) throws E {
        long start = this.nanoTime.nanoTime();
        try {
            Object object = fn.get();
            return (T)object;
        }
        catch (RuntimeException e) {
            this.errorHandler.accept(e);
            throw e;
        }
        catch (Exception e) {
            this.errorHandler.accept(e);
            throw e;
        }
        finally {
            long duration = this.nanoTime.nanoTime() - start;
            ProfileBuckets.add(this.map.get(), duration);
        }
    }

    @Override
    public <E extends Exception> void run(RunnableWithExceptionE<E> fn) throws E {
        long start = this.nanoTime.nanoTime();
        try {
            fn.run();
        }
        catch (RuntimeException e) {
            this.errorHandler.accept(e);
            throw e;
        }
        catch (Exception e) {
            this.errorHandler.accept(e);
            throw e;
        }
        finally {
            long duration = this.nanoTime.nanoTime() - start;
            ProfileBuckets.add(this.map.get(), duration);
        }
    }

    @Override
    public IProfile child(String name) {
        return new Profile(this.jmxName, this.nanoTime, this.map.child(name), this.errorHandler);
    }

    @Override
    public IProfile registerMBean() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName(this.jmxName + ":type=Profile,name=" + this.map.path());
            if (mbs.isRegistered(name)) {
                mbs.unregisterMBean(name);
            }
            mbs.registerMBean(this, name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public IProfile withErrorHandler(Consumer<Exception> errorHandler) {
        return new Profile(this.jmxName, this.nanoTime, this.map, errorHandler);
    }

    @Override
    public int getCount() {
        return this.map.get().mapAndAdd(ProfileBucket::getCount, Integer::sum);
    }

    @Override
    public long getTotalMs() {
        return this.map.get().mapAndAdd(ProfileBucket::getTotal, Long::sum) / 1000000L;
    }

    @Override
    public String getPath() {
        return this.map.path();
    }

    @Override
    public long getSnapshotMs() {
        return this.map.get().snapshot() / 1000000L;
    }

    public IProfileInfo info() {
        return new ProfileInfo(this.map.path(), this.getCount(), this.getTotalMs(), this.map.get().snapshot() / 1000000L);
    }

    @Override
    public String json() {
        HashMap map = new HashMap();
        this.map.fold(null, (acc, path, buckets) -> map.put(path, ProfileBuckets.json(buckets)));
        return MapHelpers.jsonPrint((String)"\n", map, (key, value) -> value);
    }

    @Override
    public void clear() {
        ProfileBuckets.clear(this.map.get());
    }

    public Profile(String jmxName, INanoTime nanoTime, IPathMap<ProfileBuckets<ProfileBucket>> map, Consumer<Exception> errorHandler) {
        this.jmxName = jmxName;
        this.nanoTime = nanoTime;
        this.map = map;
        this.errorHandler = errorHandler;
    }
}

