/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.profile.jboss;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;

public class JBossBeanRegistry {
    private static final ConcurrentHashMap<String, JBossBeanRegistry> SERVICES_BY_URL = new ConcurrentHashMap();
    private final List<ObjectName> mbeanNames = Collections.synchronizedList(new ArrayList());

    private JBossBeanRegistry() {
    }

    public static JBossBeanRegistry getInstance(String companyUrl) {
        return SERVICES_BY_URL.computeIfAbsent(companyUrl, url -> new JBossBeanRegistry());
    }

    public List<ObjectName> getRegisteredMBeans() {
        return Collections.unmodifiableList(this.mbeanNames);
    }

    public void register(String companyUrl, ObjectName mbeanName) {
        JBossBeanRegistry service = JBossBeanRegistry.getInstance(companyUrl);
        service.mbeanNames.add(mbeanName);
    }

    public void unregister(String companyUrl, ObjectName mbeanName) {
        JBossBeanRegistry service = JBossBeanRegistry.getInstance(companyUrl);
        service.mbeanNames.remove(mbeanName);
    }
}

