/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.optics.annotations.processors;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import one.xingyi.optics.annotations.Optics;
import one.xingyi.optics.annotations.processors.FieldDetails;
import one.xingyi.optics.annotations.processors.PackageAndClass;
import one.xingyi.optics.annotations.processors.TraversalDetails;
import one.xingyi.optics.annotations.processors.Utils;
import one.xingyi.optics.annotations.processors.ViewFieldDetails;

public final class ClassOpticsDetails {
    private final String packageName;
    private final String className;
    private final boolean addListTraversal;
    private final List<ViewFieldDetails> fieldDetails;
    private final List<TraversalDetails> traversalDetails;
    private final boolean debug;

    public String getCanonicalName() {
        return this.packageName + "." + this.className;
    }

    public PackageAndClass getPackageAndClass() {
        return new PackageAndClass(null, this.packageName, this.className);
    }

    Optional<ViewFieldDetails> find(String name) {
        return this.fieldDetails.stream().filter(vfd -> vfd.name.equals(name)).findFirst();
    }

    static ClassOpticsDetails fromFieldDetails(String packageName, String className, boolean addListTraversal, List<FieldDetails> fieldDetails, List<TraversalDetails> traversalDetails, boolean debug) {
        return new ClassOpticsDetails(packageName, className, addListTraversal, fieldDetails.stream().map(fd -> ViewFieldDetails.oneForRecord(className, fieldDetails, fd)).collect(Collectors.toList()), traversalDetails, debug);
    }

    static ElementKind selectFieldType(Consumer<String> log, Element element) {
        if (element.getKind().toString().equals("RECORD")) {
            return ElementKind.valueOf("RECORD_COMPONENT");
        }
        if (element.getKind().equals((Object)ElementKind.CLASS)) {
            return ElementKind.FIELD;
        }
        throw new RuntimeException("Optics " + element + " is not a record or a class. Kind is " + (Object)((Object)element.getKind()));
    }

    static Function<String, String> getterFn(Element element) {
        if (element.getKind().toString().equals("RECORD")) {
            return Function.identity();
        }
        if (element.getKind().equals((Object)ElementKind.CLASS)) {
            return s -> "get" + s.substring(0, 1).toUpperCase() + s.substring(1);
        }
        throw new RuntimeException("Optics " + element + " is not a record or a class. Kind is " + (Object)((Object)element.getKind()));
    }

    protected static Function<Element, ClassOpticsDetails> makeDetailFromElement(Consumer<String> log) {
        return element -> {
            Optics annotation = element.getAnnotation(Optics.class);
            boolean debug = annotation.debug();
            if (debug) {
                log.accept("Optics - Found " + element + " of kind" + (Object)((Object)element.getKind()) + " with annotation " + annotation);
            }
            ElementKind fieldKind = ClassOpticsDetails.selectFieldType(log, element);
            List<TraversalDetails> traversals = Arrays.stream(annotation.traversals()).map(TraversalDetails::fromPath).collect(Collectors.toList());
            Element pckElement = element.getEnclosingElement();
            if (!pckElement.getKind().toString().equals("PACKAGE")) {
                throw new RuntimeException("Expected package for " + element + " but got " + (Object)((Object)pckElement.getKind()));
            }
            String pckName = pckElement.toString();
            String className = element.getSimpleName().toString();
            log.accept("fieldKind" + (Object)((Object)fieldKind) + " And enclosed " + element.getEnclosedElements().stream().map(e -> (Object)((Object)e.getKind()) + " " + e).collect(Collectors.joining(",")));
            List<FieldDetails> fieldDetails = element.getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)fieldKind)).map(ClassOpticsDetails.makeFieldDetailsFromElement(ClassOpticsDetails.getterFn(element))).collect(Collectors.toList());
            return ClassOpticsDetails.fromFieldDetails(pckName, className, annotation.addListTraversal(), fieldDetails, traversals, debug);
        };
    }

    private static Function<Element, FieldDetails> makeFieldDetailsFromElement(Function<String, String> getterFn) {
        return e -> {
            String name = e.getSimpleName().toString();
            String type = e.asType().toString();
            int index = type.indexOf("<");
            String containedFieldType = index >= 0 ? type.substring(index + 1, type.lastIndexOf(">")) : null;
            String simpleCollectionType = index >= 0 ? Utils.lastSegment(type.substring(0, index)) : null;
            String getter = (String)getterFn.apply(name);
            return new FieldDetails(PackageAndClass.from(type), PackageAndClass.from(simpleCollectionType), PackageAndClass.from(containedFieldType), name, getter);
        };
    }

    private static String getContainedFieldType(String type) {
        return type.contains("<") ? type.substring(type.indexOf("<") + 1, type.lastIndexOf(">")) : null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassOpticsDetails)) {
            return false;
        }
        ClassOpticsDetails other = (ClassOpticsDetails)o;
        if (this.isAddListTraversal() != other.isAddListTraversal()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        List<ViewFieldDetails> this$fieldDetails = this.getFieldDetails();
        List<ViewFieldDetails> other$fieldDetails = other.getFieldDetails();
        if (this$fieldDetails == null ? other$fieldDetails != null : !((Object)this$fieldDetails).equals(other$fieldDetails)) {
            return false;
        }
        List<TraversalDetails> this$traversalDetails = this.getTraversalDetails();
        List<TraversalDetails> other$traversalDetails = other.getTraversalDetails();
        return !(this$traversalDetails == null ? other$traversalDetails != null : !((Object)this$traversalDetails).equals(other$traversalDetails));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAddListTraversal() ? 79 : 97);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 43 : $packageName.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        List<ViewFieldDetails> $fieldDetails = this.getFieldDetails();
        result = result * 59 + ($fieldDetails == null ? 43 : ((Object)$fieldDetails).hashCode());
        List<TraversalDetails> $traversalDetails = this.getTraversalDetails();
        result = result * 59 + ($traversalDetails == null ? 43 : ((Object)$traversalDetails).hashCode());
        return result;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isAddListTraversal() {
        return this.addListTraversal;
    }

    public List<ViewFieldDetails> getFieldDetails() {
        return this.fieldDetails;
    }

    public List<TraversalDetails> getTraversalDetails() {
        return this.traversalDetails;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public String toString() {
        return "ClassOpticsDetails(packageName=" + this.getPackageName() + ", className=" + this.getClassName() + ", addListTraversal=" + this.isAddListTraversal() + ", fieldDetails=" + this.getFieldDetails() + ", traversalDetails=" + this.getTraversalDetails() + ", debug=" + this.isDebug() + ")";
    }

    public ClassOpticsDetails(String packageName, String className, boolean addListTraversal, List<ViewFieldDetails> fieldDetails, List<TraversalDetails> traversalDetails, boolean debug) {
        this.packageName = packageName;
        this.className = className;
        this.addListTraversal = addListTraversal;
        this.fieldDetails = fieldDetails;
        this.traversalDetails = traversalDetails;
        this.debug = debug;
    }
}

