/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.optics.annotations.serialise;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import one.xingyi.optics.annotations.processors.PackageAndClass;
import one.xingyi.optics.annotations.serialise.IAnnotationProcessorLoader;

class CachedAnnotationProcessorLoader<From, T>
implements IAnnotationProcessorLoader<From, T> {
    private final IAnnotationProcessorLoader<From, T> loader;
    private final ConcurrentHashMap<PackageAndClass, T> cache;
    private final Function<From, PackageAndClass> fromToClassName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T load(From from) throws IOException {
        PackageAndClass className = this.fromToClassName.apply(from);
        if (this.cache.containsKey(className)) {
            return this.cache.get(className);
        }
        ConcurrentHashMap<PackageAndClass, T> concurrentHashMap = this.cache;
        synchronized (concurrentHashMap) {
            if (this.cache.containsKey(className)) {
                return this.cache.get(className);
            }
            T t = this.loader.load(from);
            this.cache.put(className, t);
            return t;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CachedAnnotationProcessorLoader)) {
            return false;
        }
        CachedAnnotationProcessorLoader other = (CachedAnnotationProcessorLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IAnnotationProcessorLoader<From, T> this$loader = this.getLoader();
        IAnnotationProcessorLoader<From, T> other$loader = other.getLoader();
        if (this$loader == null ? other$loader != null : !this$loader.equals(other$loader)) {
            return false;
        }
        ConcurrentHashMap<PackageAndClass, T> this$cache = this.getCache();
        ConcurrentHashMap<PackageAndClass, T> other$cache = other.getCache();
        if (this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache)) {
            return false;
        }
        Function<From, PackageAndClass> this$fromToClassName = this.getFromToClassName();
        Function<From, PackageAndClass> other$fromToClassName = other.getFromToClassName();
        return !(this$fromToClassName == null ? other$fromToClassName != null : !this$fromToClassName.equals(other$fromToClassName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CachedAnnotationProcessorLoader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IAnnotationProcessorLoader<From, T> $loader = this.getLoader();
        result = result * 59 + ($loader == null ? 43 : $loader.hashCode());
        ConcurrentHashMap<PackageAndClass, T> $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        Function<From, PackageAndClass> $fromToClassName = this.getFromToClassName();
        result = result * 59 + ($fromToClassName == null ? 43 : $fromToClassName.hashCode());
        return result;
    }

    public IAnnotationProcessorLoader<From, T> getLoader() {
        return this.loader;
    }

    public ConcurrentHashMap<PackageAndClass, T> getCache() {
        return this.cache;
    }

    public Function<From, PackageAndClass> getFromToClassName() {
        return this.fromToClassName;
    }

    public String toString() {
        return "CachedAnnotationProcessorLoader(loader=" + this.getLoader() + ", cache=" + this.getCache() + ", fromToClassName=" + this.getFromToClassName() + ")";
    }

    public CachedAnnotationProcessorLoader(IAnnotationProcessorLoader<From, T> loader, ConcurrentHashMap<PackageAndClass, T> cache, Function<From, PackageAndClass> fromToClassName) {
        this.loader = loader;
        this.cache = cache;
        this.fromToClassName = fromToClassName;
    }
}

