/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.reference2.person.server.domain;

import java.util.Objects;
import java.util.function.Function;
import one.xingyi.core.annotations.XingYiGenerated;
import one.xingyi.core.marshelling.ContextForJson;
import one.xingyi.core.marshelling.HasJson;
import one.xingyi.core.marshelling.HasJsonWithLinks;
import one.xingyi.core.marshelling.JsonWriter;
import one.xingyi.reference2.address.server.domain.IAddress;
import one.xingyi.reference2.person.server.companion.PersonCompanion;
import one.xingyi.reference2.person.server.domain.IPerson;
import one.xingyi.reference2.telephone.server.domain.ITelephoneNumber;

public class Person
implements HasJson<ContextForJson>,
IPerson,
HasJsonWithLinks<ContextForJson, Person> {
    final String name;
    final Integer age;
    final IAddress address;
    final ITelephoneNumber telephone;

    @XingYiGenerated
    public Person(String name, Integer age, IAddress address, ITelephoneNumber telephone) {
        this.name = name;
        this.age = age;
        this.address = address;
        this.telephone = telephone;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Integer age() {
        return this.age;
    }

    @Override
    public Person withage(Integer age) {
        return new Person(this.name, age, this.address, this.telephone);
    }

    @Override
    public IAddress address() {
        return this.address;
    }

    @Override
    public Person withaddress(IAddress address) {
        return new Person(this.name, this.age, address, this.telephone);
    }

    @Override
    public ITelephoneNumber telephone() {
        return this.telephone;
    }

    @Override
    public Person withtelephone(ITelephoneNumber telephone) {
        return new Person(this.name, this.age, this.address, telephone);
    }

    @XingYiGenerated
    public <J> J toJson(JsonWriter<J> jsonWriter, ContextForJson context) {
        return (J)jsonWriter.makeObject(new Object[]{"name", this.name, "age", this.age, "address", this.address.toJson(jsonWriter, context), "telephone", this.telephone.toJson(jsonWriter, context)});
    }

    @XingYiGenerated
    public <J> J toJsonWithLinks(JsonWriter<J> jsonWriter, ContextForJson context, Function<Person, String> stateFn) {
        return (J)jsonWriter.makeObject(new Object[]{"name", this.name, "age", this.age, "address", this.address.toJson(jsonWriter, context), "telephone", this.telephone.toJson(jsonWriter, context), "_links", context.links(jsonWriter, (Object)this, stateFn, PersonCompanion.companion.stateMap)});
    }

    @XingYiGenerated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person other = (Person)o;
        return Objects.equals(this.name, other.name) && Objects.equals(this.age, other.age) && Objects.equals(this.address, other.address) && Objects.equals(this.telephone, other.telephone);
    }

    @XingYiGenerated
    public int hashCode() {
        return Objects.hash(this.name, this.age, this.address, this.telephone);
    }

    @XingYiGenerated
    public String toString() {
        return "Person(" + this.name + "," + this.age + "," + this.address + "," + this.telephone + ")";
    }
}

