/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.reference3;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import junit.framework.TestCase;
import one.xingyi.core.client.IResourceList;
import one.xingyi.core.client.MirroredResourceList;
import one.xingyi.core.endpoints.EndPoint;
import one.xingyi.core.endpoints.EndpointConfig;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.httpClient.HttpServiceCompletableFuture;
import one.xingyi.core.marshelling.JsonParser;
import one.xingyi.core.marshelling.JsonParserAndWriter;
import one.xingyi.reference3.PersonServer;
import one.xingyi.reference3.address.client.view.AddressLine12View;
import one.xingyi.reference3.person.PersonController;
import one.xingyi.reference3.person.client.view.PersonAddress12View;
import one.xingyi.reference3.person.client.view.PersonAddresses12View;
import one.xingyi.reference3.person.client.view.PersonLine12View;
import one.xingyi.reference3.person.server.companion.PersonCompanion;
import one.xingyi.reference3.person.server.controller.IPersonController;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractDeprecated3Tests<J> {
    EndPoint entityEndpoints;
    HttpServiceCompletableFuture rawService;

    public AbstractDeprecated3Tests() {
        this.entityEndpoints = EndPoint.compose((List)new PersonServer(this.config(), (IPersonController)new PersonController((JsonParser)this.config().parserAndWriter)).allEndpoints());
    }

    Function<ServiceRequest, CompletableFuture<ServiceResponse>> httpClient() {
        return EndPoint.toKliesli((EndPoint)this.entityEndpoints);
    }

    abstract EndpointConfig<J> config();

    abstract boolean supportsReadingJson();

    HttpServiceCompletableFuture service() {
        if (this.rawService == null) {
            Function<ServiceRequest, CompletableFuture<ServiceResponse>> client = this.httpClient();
            this.rawService = HttpServiceCompletableFuture.lensService((String)"http://localhost:9000", (JsonParserAndWriter)this.config().parserAndWriter, client);
        }
        return this.rawService;
    }

    @Test
    public void testJavascriptForLine1() {
        Objects.requireNonNull(PersonCompanion.companion);
        Assert.assertFalse((String)"function lens_Person_name(){return lens('name');};\nfunction lens_Person_age(){return lens('age');};\nfunction lens_Person_addresses(){return lens('addresses');};\nfunction lens_Person_telephone(){return lens('telephone');};\nfunction lens_Person_address(){return compose(lens_Person_addresses(), lensForFirstItemInList());};\nfunction lens_Person_line1(){return compose(lens_Person_address(), lens('line1'));};\nfunction lens_Person_line2(){return compose(lens_Person_address(), lens('line2'));};\n", (boolean)PersonCompanion.companion.javascript().contains("return lens('line1')"));
        Objects.requireNonNull(PersonCompanion.companion);
        Assert.assertTrue((String)"function lens_Person_name(){return lens('name');};\nfunction lens_Person_age(){return lens('age');};\nfunction lens_Person_addresses(){return lens('addresses');};\nfunction lens_Person_telephone(){return lens('telephone');};\nfunction lens_Person_address(){return compose(lens_Person_addresses(), lensForFirstItemInList());};\nfunction lens_Person_line1(){return compose(lens_Person_address(), lens('line1'));};\nfunction lens_Person_line2(){return compose(lens_Person_address(), lens('line2'));};\n", (boolean)PersonCompanion.companion.javascript().contains("return compose(lens_Person_address(), lens('line2'));"));
    }

    @Test
    public void testCanReadLine1and2() throws ExecutionException, InterruptedException {
        TestCase.assertEquals((String)"someLine1", (String)((String)PersonLine12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", PersonLine12View::line1).get()));
        TestCase.assertEquals((String)"someLine2", (String)((String)PersonLine12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", PersonLine12View::line2).get()));
    }

    @Test
    public void testCanReadLine1and2ViaAddress() throws ExecutionException, InterruptedException {
        TestCase.assertEquals((String)"someLine1", (String)((String)PersonAddress12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", v -> v.address().line1()).get()));
        TestCase.assertEquals((String)"someLine2", (String)((String)PersonAddress12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", v -> v.address().line2()).get()));
    }

    @Test
    public void testCanReadLine1and2ViaAddresses() throws ExecutionException, InterruptedException {
        TestCase.assertEquals((String)"someLine1", (String)((String)PersonAddresses12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", v -> ((AddressLine12View)v.addresses().get(0)).line1()).get()));
        TestCase.assertEquals((String)"someLine2", (String)((String)PersonAddresses12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", v -> ((AddressLine12View)v.addresses().get(0)).line2()).get()));
    }

    @Test
    public void testCanSizeOfReadLine1and2ViaAddresses() throws ExecutionException, InterruptedException {
        TestCase.assertEquals((int)1, (int)((Integer)PersonAddresses12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", v -> v.addresses().size()).get()));
        TestCase.assertEquals((int)1, (int)((Integer)PersonAddresses12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", v -> v.addresses().size()).get()));
    }

    @Test
    public void testCanChangeItemsInList() throws ExecutionException, InterruptedException {
        if (this.supportsReadingJson()) {
            TestCase.assertEquals((String)"newLine1", (String)((String)PersonAddresses12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", v -> {
                AddressLine12View newItem = ((AddressLine12View)v.addresses().get(0)).withline1("newLine1");
                IResourceList addresses = v.addresses();
                MirroredResourceList newList = (MirroredResourceList)addresses.withItem(0, (Object)newItem);
                ScriptObjectMirror newListAsJava = newList.mirror;
                return ((AddressLine12View)newList.get(0)).line1();
            }).get()));
            TestCase.assertEquals((String)"newLine2", (String)((String)PersonAddresses12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", v -> ((AddressLine12View)v.addresses().withItem(0, (Object)((AddressLine12View)v.addresses().get(0)).withline2("newLine2")).get(0)).line2()).get()));
        }
    }
}

