package one.xingyi.core.httpClient;
import lombok.RequiredArgsConstructor;
import one.xingyi.core.client.IXingYi;
import one.xingyi.core.client.IXingYiFactory;
import one.xingyi.core.http.JavaHttpClient;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.httpClient.client.viewcompanion.UrlPatternCompanion;
import one.xingyi.core.httpClient.client.view.UrlPattern;
import one.xingyi.core.marshelling.IXingYiResponseSplitter;
import one.xingyi.core.marshelling.JsonParserAndWriter;
import one.xingyi.core.sdk.IXingYiClientResource;
import one.xingyi.core.sdk.IXingYiRemoteAccessDetails;
import one.xingyi.core.sdk.IXingYiView;
import one.xingyi.core.utils.IdAndValue;
import one.xingyi.core.utils.StateFn;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
//TODO This whole class needs sorting out. It is far too big and does too much
//It also needs to work with the 'monaddefn'
public interface HttpServiceCompletableFuture {

    static HttpServiceCompletableFuture javascriptService(String protocolAndHost, Function<ServiceRequest, CompletableFuture<ServiceResponse>> delegate) {
        return new DefaultHttpServiceCompletableFuture(protocolAndHost, delegate, IXingYiFactory.simple, IXingYiResponseSplitter.splitter(delegate));
    }
    static <J>HttpServiceCompletableFuture lensService(String protocolAndHost, JsonParserAndWriter<J> json, Function<ServiceRequest, CompletableFuture<ServiceResponse>> delegate) {
        return new DefaultHttpServiceCompletableFuture(protocolAndHost, delegate, IXingYiFactory.lensFactory(json), IXingYiResponseSplitter.splitter(delegate));
    }
    //static HttpServiceCompletableFuture defaultServiceWithSimpleJavaclient(String protocolAndHost) {return defaultService(protocolAndHost, JavaHttpClient.client); }

    <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Result> primitive(
            IXingYiRemoteAccessDetails<Entity, View> clientMaker,
            String method,
            String url,
            Function<View, Result> fn);

    public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Boolean> primitiveForBoolean(String method, String url);
    <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<IdAndValue<View>> primitiveForIdAndValue(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String method, String url,View view);
    default CompletableFuture<String> getUrlPattern(String bookmark) {
        return UrlPatternCompanion.companion.primitive(this, "get", bookmark, UrlPattern::urlPattern);
    }

    <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Result> get(
            IXingYiRemoteAccessDetails<Entity, View> clientMaker,
            String id,
            Function<View, Result> fn);
    public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Optional<Result>> primitiveForOptional(
            IXingYiRemoteAccessDetails<Entity, View> clientMaker, String method, String url, Function<View, Result> fn);

    <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Optional<Result>> getOptional(
            IXingYiRemoteAccessDetails<Entity, View> clientMaker,
            String id,
            Function<View, Result> fn);
    <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> CompletableFuture<View> create(
            IXingYiRemoteAccessDetails<Entity, View> clientMaker,
            String id);
    <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> CompletableFuture<IdAndValue<View>> createWithoutId(IXingYiRemoteAccessDetails<Entity, View> clientMaker, View view);
    <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> CompletableFuture<Boolean> delete(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String id);
    <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> CompletableFuture<View> edit(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String id, Function<View, View> fn);
    <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> CompletableFuture<IdAndValue<View>> prototypeNoId(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String prototypeId,  Function<View, View> fn);
    <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> CompletableFuture<View> prototype(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String prototypeId, String id, Function<View, View> fn);
    //    <Entity extends IXingYiClientEntity, View extends IXingYiView<Entity>> CompletableFuture<View> post(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String urlPattern, String id);
    <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Result> process(
            IXingYiRemoteAccessDetails<Entity, View> clientMaker, String action, String id, StateFn<View, Result> stateFn);

}


@RequiredArgsConstructor
class DefaultHttpServiceCompletableFuture implements HttpServiceCompletableFuture {
    final String protocolAndHost;
    final Function<ServiceRequest, CompletableFuture<ServiceResponse>> service;
    final IXingYiFactory factory;
    final IXingYiResponseSplitter splitter;


    <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> Function<ServiceResponse, CompletableFuture<View>> makeEntity(IXingYiRemoteAccessDetails<Entity, View> clientMaker, ServiceRequest serviceRequest) {
        return serviceResponse -> IXingYiResponseSplitter.fromServiceResponse(factory,splitter, clientMaker, serviceRequest, serviceResponse, Function.identity());
    }
    <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> Function<ServiceResponse, CompletableFuture<Optional<View>>> makeOptionalEntity(IXingYiRemoteAccessDetails<Entity, View> clientMaker, ServiceRequest serviceRequest) {
        return serviceResponse -> {
            if (serviceResponse.statusCode == 404) return CompletableFuture.completedFuture(Optional.empty());
            return IXingYiResponseSplitter.fromServiceResponse(factory, splitter,clientMaker, serviceRequest, serviceResponse, Optional::of);
        };
    }

    @SuppressWarnings("unchecked") <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> Function<ServiceResponse, CompletableFuture<IdAndValue<View>>> makeIdAndValue(IXingYiRemoteAccessDetails<Entity, View> clientMaker, ServiceRequest serviceRequest) {
        return serviceResponse -> IXingYiResponseSplitter.fromServiceResponse(factory, splitter,clientMaker, serviceRequest, serviceResponse, view -> view.xingYi().getIdAndValue(view.mirror(), clientMaker));
    }

    Function<ServiceResponse, Boolean> makeBoolean(ServiceRequest serviceRequest) {
        return serviceResponse -> {
            try {
                return Boolean.parseBoolean(serviceResponse.body);
            } catch (Exception e) {
                throw new RuntimeException("Have thrown unexpected exception.\n" + serviceRequest + "\n" + serviceResponse, e);
            }
        };
    }


    @Override public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Result> primitive(
            IXingYiRemoteAccessDetails<Entity, View> clientMaker, String method, String url, Function<View, Result> fn) {
        ServiceRequest serviceRequest = new ServiceRequest(method, url.startsWith("/") ? protocolAndHost + url : url, List.of(), "");
        return service.apply(serviceRequest).thenCompose(sr->makeEntity(clientMaker, serviceRequest).apply(sr).thenApply(fn));
    }
    @Override public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Optional<Result>> primitiveForOptional(
            IXingYiRemoteAccessDetails<Entity, View> clientMaker, String method, String url, Function<View, Result> fn) {
        ServiceRequest serviceRequest = new ServiceRequest(method, url.startsWith("/") ? protocolAndHost + url : url, List.of(), "");
        return service.apply(serviceRequest).thenCompose(sr -> makeOptionalEntity(clientMaker, serviceRequest).apply(sr).thenApply(optView->optView.map(fn)));
    }
    @Override public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Boolean> primitiveForBoolean(String method, String url) {
        ServiceRequest serviceRequest = new ServiceRequest(method, url.startsWith("/") ? protocolAndHost + url : url, List.of(), "");
        return service.apply(serviceRequest).thenApply(makeBoolean(serviceRequest));
    }
    @Override public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<IdAndValue<View>> primitiveForIdAndValue(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String method, String url,View view) {
        ServiceRequest serviceRequest = new ServiceRequest(method, url.startsWith("/") ? protocolAndHost + url : url, List.of(), view.xingYi().render("json", view));
        return service.apply(serviceRequest).thenCompose(makeIdAndValue(clientMaker, serviceRequest));
    }
    @Override public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Result>
    get(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String id, Function<View, Result> fn) {
        return getUrlPattern(clientMaker.bookmark()).thenCompose(urlPattern -> primitive(clientMaker, "get", urlPattern.replace("{id}", id), fn));//TODO UrlEncoding
    }
    @Override public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Optional<Result>> getOptional(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String id, Function<View, Result> fn) {
        return getUrlPattern(clientMaker.bookmark()).thenCompose(urlPattern -> primitiveForOptional(clientMaker, "get", urlPattern.replace("{id}", id), fn));
    }
    @Override public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> CompletableFuture<View>
    create(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String id) {
        return getUrlPattern(clientMaker.bookmark()).thenCompose(urlPattern -> primitive(clientMaker, "post", urlPattern.replace("{id}", id), v -> v));
    }
    @Override public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> CompletableFuture<IdAndValue<View>> createWithoutId(IXingYiRemoteAccessDetails<Entity, View> clientMaker, View view) {
        return getUrlPattern(clientMaker.bookmark()).thenCompose(urlPattern -> primitiveForIdAndValue(clientMaker, "post", urlPattern.replace("/{id}", ""),view));
    }
    @Override public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> CompletableFuture<Boolean> delete(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String id) {
        return getUrlPattern(clientMaker.bookmark()).thenCompose(urlPattern -> primitiveForBoolean("delete", urlPattern.replace("{id}", id)));
    }
    @Override public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> CompletableFuture<View> edit(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String id, Function<View, View> fn) {
        return getUrlPattern(clientMaker.bookmark()).thenCompose(urlPattern -> {
            String url = urlPattern.replace("{id}", id);
            CompletableFuture<View> original = primitive(clientMaker, "get", url, fn);
            return original.thenCompose(o -> {
                @SuppressWarnings("unchecked")
                String json = o.xingYi().render("json", o);
                ServiceRequest serviceRequest = new ServiceRequest("put", url.startsWith("/") ? protocolAndHost + url : url, List.of(), json);
                return service.apply(serviceRequest).thenCompose(makeEntity(clientMaker, serviceRequest));
            });
        });
    }
@Override public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> CompletableFuture<IdAndValue<View>> prototypeNoId(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String prototypeId,  Function<View, View> fn) {
        return getUrlPattern(clientMaker.bookmark()).thenCompose(urlPattern -> {
            String prototypeUrl = urlPattern.replace("{id}", prototypeId);
            String finalUrl = urlPattern.replace("/{id}", "");
            CompletableFuture<View> original = primitive(clientMaker, "get", prototypeUrl, fn);
            return original.thenCompose(o -> {
                @SuppressWarnings("unchecked")
                String json = o.xingYi().render("json", o);
                ServiceRequest serviceRequest = new ServiceRequest("post", finalUrl.startsWith("/") ? protocolAndHost + finalUrl : finalUrl, List.of(), json);
                return service.apply(serviceRequest).thenCompose(makeIdAndValue(clientMaker, serviceRequest));
            });
        });
    }

@Override public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>> CompletableFuture<View> prototype(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String prototypeId, String id, Function<View, View> fn) {
        return getUrlPattern(clientMaker.bookmark()).thenCompose(urlPattern -> {
            String prototypeUrl = urlPattern.replace("{id}", prototypeId);
            String finalUrl = urlPattern.replace("{id}", id);
            CompletableFuture<View> original = primitive(clientMaker, "get", prototypeUrl, fn);
            return original.thenCompose(o -> {
                @SuppressWarnings("unchecked")
                String json = o.xingYi().render("json", o);
                ServiceRequest serviceRequest = new ServiceRequest("put", finalUrl.startsWith("/") ? protocolAndHost + finalUrl : finalUrl, List.of(), json);
                return service.apply(serviceRequest).thenCompose(makeEntity(clientMaker, serviceRequest));
            });
        });
    }


    @Override public <Entity extends IXingYiClientResource, View extends IXingYiView<Entity>, Result> CompletableFuture<Result> process(IXingYiRemoteAccessDetails<Entity, View> clientMaker, String action, String id, StateFn<View, Result> stateFn) {
        throw new RuntimeException("not implemented yet");
    }
}


