/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.reference4;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import junit.framework.TestCase;
import one.xingyi.core.client.IResourceList;
import one.xingyi.core.client.MirroredResourceList;
import one.xingyi.core.endpoints.EndPoint;
import one.xingyi.core.endpoints.EndpointConfig;
import one.xingyi.core.http.ServiceRequest;
import one.xingyi.core.http.ServiceResponse;
import one.xingyi.core.httpClient.HttpServiceCompletableFuture;
import one.xingyi.reference4.PersonServer;
import one.xingyi.reference4.address.client.view.AddressLine12View;
import one.xingyi.reference4.person.PersonController;
import one.xingyi.reference4.person.client.view.PersonAddress12View;
import one.xingyi.reference4.person.client.view.PersonAddresses12View;
import one.xingyi.reference4.person.client.view.PersonLine12View;
import one.xingyi.reference4.person.server.controller.IPersonController;
import org.junit.Test;

public abstract class AbstractDeprecated4Tests<J> {
    EndPoint entityEndpoints = EndPoint.compose((List)new PersonServer(this.config(), (IPersonController)new PersonController()).allEndpoints());
    HttpServiceCompletableFuture rawService;

    Function<ServiceRequest, CompletableFuture<ServiceResponse>> httpClient() {
        return EndPoint.toKliesli((EndPoint)this.entityEndpoints);
    }

    abstract EndpointConfig<J> config();

    abstract boolean supportsReadingJson();

    HttpServiceCompletableFuture service() {
        if (this.rawService == null) {
            Function<ServiceRequest, CompletableFuture<ServiceResponse>> client = this.httpClient();
            this.rawService = HttpServiceCompletableFuture.javascriptService((String)"http://localhost:9000", client);
        }
        return this.rawService;
    }

    @Test
    public void testCanReadLine1and2() throws ExecutionException, InterruptedException {
        TestCase.assertEquals((String)"someLine1", (String)((String)PersonLine12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", PersonLine12View::line1).get()));
        TestCase.assertEquals((String)"someLine2", (String)((String)PersonLine12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", PersonLine12View::line2).get()));
    }

    @Test
    public void testCanReadLine1and2ViaAddress() throws ExecutionException, InterruptedException {
        TestCase.assertEquals((String)"someLine1", (String)((String)PersonAddress12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", v -> v.address().line1()).get()));
        TestCase.assertEquals((String)"someLine2", (String)((String)PersonAddress12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", v -> v.address().line2()).get()));
    }

    @Test
    public void testCanReadLine1and2ViaAddresses() throws ExecutionException, InterruptedException {
        TestCase.assertEquals((String)"someLine1", (String)((String)PersonAddresses12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", v -> ((AddressLine12View)v.addresses().get(0)).line1()).get()));
        TestCase.assertEquals((String)"someLine2", (String)((String)PersonAddresses12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", v -> ((AddressLine12View)v.addresses().get(0)).line2()).get()));
    }

    @Test
    public void testCanSizeOfReadLine1and2ViaAddresses() throws ExecutionException, InterruptedException {
        TestCase.assertEquals((int)1, (int)((Integer)PersonAddresses12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", v -> v.addresses().size()).get()));
        TestCase.assertEquals((int)1, (int)((Integer)PersonAddresses12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", v -> v.addresses().size()).get()));
    }

    @Test
    public void testCanChangeItemsInList() throws ExecutionException, InterruptedException {
        if (this.supportsReadingJson()) {
            TestCase.assertEquals((String)"newLine1", (String)((String)PersonAddresses12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", v -> {
                AddressLine12View newItem = ((AddressLine12View)v.addresses().get(0)).withline1("newLine1");
                IResourceList addresses = v.addresses();
                MirroredResourceList newList = (MirroredResourceList)addresses.withItem(0, (Object)newItem);
                ScriptObjectMirror newListAsJava = newList.mirror;
                return ((AddressLine12View)newList.get(0)).line1();
            }).get()));
            TestCase.assertEquals((String)"newLine2", (String)((String)PersonAddresses12View.get((HttpServiceCompletableFuture)this.service(), (String)"id1", v -> ((AddressLine12View)v.addresses().withItem(0, (Object)((AddressLine12View)v.addresses().get(0)).withline2("newLine2")).get(0)).line2()).get()));
        }
    }
}

