/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.optics;

import junit.framework.TestCase;
import one.xingyi.core.client.IResourceList;
import one.xingyi.core.marshelling.JsonParserAndWriter;
import one.xingyi.core.optics.Lens;
import one.xingyi.core.optics.lensLanguage.LensDefnStore;
import one.xingyi.core.optics.lensLanguage.LensStore;
import one.xingyi.core.optics.lensLanguage.LensStoreParser;
import one.xingyi.core.utils.Strings;
import org.junit.Test;

public abstract class LenStoreWithJsonTest<J> {
    protected abstract JsonParserAndWriter<J> parser();

    @Test
    public void testCanAccessStringLens() {
        String json = Strings.changeQuotes((String)"{'name':'phil','addresses':[{'line1':'someLine1'}]}");
        Object j = this.parser().parse(json);
        LensDefnStore lensDefnStore = (LensDefnStore)LensStoreParser.simple().apply((Object)"person_name=name/string");
        LensStore store = lensDefnStore.makeStore(this.parser());
        TestCase.assertEquals((String)"phil", (String)((String)store.stringLens("person_name").get(j)));
    }

    @Test
    public void testCanAccessChildLensThenString() {
        String json = Strings.changeQuotes((String)"{'name':'phil','age':23,'addresses':[{'line1':'someLine1'}]}");
        Object j = this.parser().parse(json);
        LensDefnStore lensDefnStore = (LensDefnStore)LensStoreParser.simple().apply((Object)"person_age=age/int");
        LensStore store = lensDefnStore.makeStore(this.parser());
        TestCase.assertEquals((int)23, (int)((Integer)store.integerLens("person_age").get(j)));
    }

    @Test
    public void testCanAccessChildThenString() {
        String json = Strings.changeQuotes((String)"{'name':'phil','age':23,'address':{'line1':'someLine1'}}");
        Object j = this.parser().parse(json);
        LensDefnStore lensDefnStore = (LensDefnStore)LensStoreParser.simple().apply((Object)"person_line1=address/address,line1/string");
        LensStore store = lensDefnStore.makeStore(this.parser());
        TestCase.assertEquals((Object)"someLine1", (Object)store.integerLens("person_line1").get(j));
    }

    @Test
    public void testCanAccessListThenString() {
        String json = Strings.changeQuotes((String)"{'name':'phil','age':23,'addresses':[{'line1':'someLine1a'},{'line1':'someLine1b'}]}");
        Object j = this.parser().parse(json);
        LensDefnStore lensDefnStore = (LensDefnStore)LensStoreParser.simple().apply((Object)"person_address=addresses/*address\naddress_line1=line1/string");
        LensStore store = lensDefnStore.makeStore(this.parser());
        Lens listLens = store.listLens("person_address");
        IResourceList addresses = (IResourceList)listLens.get(j);
        TestCase.assertEquals((String)"someLine1a", (String)((String)store.stringLens("address_line1").get(addresses.get(0))));
        TestCase.assertEquals((String)"someLine1b", (String)((String)store.stringLens("address_line1").get(addresses.get(1))));
    }

    @Test
    public void testCanChangeListThenString() {
        String json = Strings.changeQuotes((String)"{'name':'phil','age':23,'addresses':[{'line1':'someLine1a'},{'line1':'someLine1b'}]}");
        Object j = this.parser().parse(json);
        LensDefnStore lensDefnStore = (LensDefnStore)LensStoreParser.simple().apply((Object)"person_address=addresses/*address\naddress_line1=line1/string");
        LensStore store = lensDefnStore.makeStore(this.parser());
        Lens listLens = store.listLens("person_address");
        Lens stringLens = store.stringLens("address_line1");
        IResourceList addresses = (IResourceList)listLens.get(j);
        IResourceList newAddresses = addresses.withItem(0, stringLens.set(addresses.get(0), (Object)"newLine1"));
        TestCase.assertEquals((String)"someLine1a", (String)((String)store.stringLens("address_line1").get(addresses.get(0))));
        TestCase.assertEquals((String)"someLine1b", (String)((String)store.stringLens("address_line1").get(addresses.get(1))));
        TestCase.assertEquals((String)"newLine1", (String)((String)store.stringLens("address_line1").get(newAddresses.get(0))));
        TestCase.assertEquals((String)"someLine1b", (String)((String)store.stringLens("address_line1").get(newAddresses.get(1))));
        Object newJ = listLens.set(j, (Object)newAddresses);
        TestCase.assertEquals((String)"someLine1a", (String)((String)stringLens.get(((IResourceList)listLens.get(j)).get(0))));
        TestCase.assertEquals((String)"newLine1", (String)((String)stringLens.get(((IResourceList)listLens.get(newJ)).get(0))));
    }

    @Test
    public void testCanAccessFirstItemInListThenString() {
        String json = Strings.changeQuotes((String)"{'name':'phil','age':23,'addresses':[{'line1':'someLine1a'},{'line1':'someLine1b'}]}");
        Object j = this.parser().parse(json);
        LensDefnStore lensDefnStore = (LensDefnStore)LensStoreParser.simple().apply((Object)"person_address=addresses/*address,{firstItem},line1/string\naddress_line1=line1/string");
        LensStore store = lensDefnStore.makeStore(this.parser());
        Lens stringLens = store.stringLens("person_address");
        TestCase.assertEquals((String)"someLine1a", (String)((String)stringLens.get(j)));
        Object newJ = stringLens.set(j, (Object)"newLine1");
        TestCase.assertEquals((String)"someLine1a", (String)((String)stringLens.get(j)));
        TestCase.assertEquals((String)"newLine1", (String)((String)stringLens.get(newJ)));
    }

    @Test
    public void testCanUseIdentity() {
        String json = Strings.changeQuotes((String)"{'name':'phil','age':23, 'line1':'someLine1a', 'line2':'someLine2'}");
        Object j = this.parser().parse(json);
        LensDefnStore lensDefnStore = (LensDefnStore)LensStoreParser.simple().apply((Object)"person_line1={identity},line1/String");
        LensStore store = lensDefnStore.makeStore(this.parser());
        Lens stringLens = store.stringLens("person_line1");
        TestCase.assertEquals((String)"someLine1a", (String)((String)stringLens.get(j)));
        Object newJ = stringLens.set(j, (Object)"newLine1");
        TestCase.assertEquals((String)"someLine1a", (String)((String)stringLens.get(j)));
        TestCase.assertEquals((String)"newLine1", (String)((String)stringLens.get(newJ)));
    }

    @Test
    public void testCanUseItemAsList() {
        String json = Strings.changeQuotes((String)"{'name':'phil','age':23,'addresses':{'line1':'someLine1a'}}}");
        Object j = this.parser().parse(json);
        LensDefnStore lensDefnStore = (LensDefnStore)LensStoreParser.simple().apply((Object)"person_address=addresses/address,{itemAsList}\naddress_line1=line1/string");
        LensStore store = lensDefnStore.makeStore(this.parser());
        Lens listLens = store.listLens("person_address");
        IResourceList addresses = (IResourceList)listLens.get(j);
        TestCase.assertEquals((String)"someLine1a", (String)((String)store.stringLens("address_line1").get(addresses.get(0))));
    }
}

