/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.optics;

import java.util.List;
import one.xingyi.core.optics.lensLanguage.DoubleLensDefn;
import one.xingyi.core.optics.lensLanguage.FirstItemInListDefn;
import one.xingyi.core.optics.lensLanguage.IdentityDefn;
import one.xingyi.core.optics.lensLanguage.IntegerLensDefn;
import one.xingyi.core.optics.lensLanguage.ItemAsListDefn;
import one.xingyi.core.optics.lensLanguage.LensDefnStore;
import one.xingyi.core.optics.lensLanguage.LensLine;
import one.xingyi.core.optics.lensLanguage.LensLineParser;
import one.xingyi.core.optics.lensLanguage.LensStoreParser;
import one.xingyi.core.optics.lensLanguage.LensValueParser;
import one.xingyi.core.optics.lensLanguage.ListLensDefn;
import one.xingyi.core.optics.lensLanguage.StringLensDefn;
import one.xingyi.core.optics.lensLanguage.ViewLensDefn;
import one.xingyi.core.utils.Lists;
import org.junit.Assert;
import org.junit.Test;

public class LensLanguageTest {
    LensValueParser lensParser = LensValueParser.simple();
    LensLineParser lineParser = LensLineParser.simple();
    LensStoreParser storeParser = LensStoreParser.simple();

    @Test
    public void testValueParser() {
        Assert.assertEquals(List.of(new StringLensDefn("line1")), (Object)this.lensParser.apply((Object)"line1/string"));
        Assert.assertEquals(List.of(new IntegerLensDefn("line1")), (Object)this.lensParser.apply((Object)"line1/integer"));
        Assert.assertEquals(List.of(new DoubleLensDefn("line1")), (Object)this.lensParser.apply((Object)"line1/double"));
        Assert.assertEquals(List.of(new ViewLensDefn("a", "address")), (Object)this.lensParser.apply((Object)"a/address"));
        Assert.assertEquals(List.of(new ListLensDefn("a", "address")), (Object)this.lensParser.apply((Object)"a/*address"));
        Assert.assertEquals(List.of(new FirstItemInListDefn()), (Object)this.lensParser.apply((Object)"{firstItem}"));
        Assert.assertEquals(List.of(new IdentityDefn()), (Object)this.lensParser.apply((Object)"{identity}"));
        Assert.assertEquals(List.of(new ItemAsListDefn()), (Object)this.lensParser.apply((Object)"{itemAsList}"));
    }

    @Test
    public void testChildThenValueParser() {
        Assert.assertEquals(List.of(new ViewLensDefn("child", "childClass"), new StringLensDefn("line1")), (Object)this.lensParser.apply((Object)"child/childClass,line1/string"));
        Assert.assertEquals(List.of(new ViewLensDefn("child", "childClass"), new IntegerLensDefn("line1")), (Object)this.lensParser.apply((Object)"child/childClass,line1/integer"));
        Assert.assertEquals(List.of(new ViewLensDefn("child", "childClass"), new DoubleLensDefn("line1")), (Object)this.lensParser.apply((Object)"child/childClass,line1/double"));
        Assert.assertEquals(List.of(new ViewLensDefn("child", "childClass"), new ViewLensDefn("a", "address")), (Object)this.lensParser.apply((Object)"child/childClass,a/address"));
        Assert.assertEquals(List.of(new ViewLensDefn("child", "childClass"), new ListLensDefn("a", "address")), (Object)this.lensParser.apply((Object)"child/childClass,a/*address"));
        Assert.assertEquals(List.of(new ViewLensDefn("child", "childClass"), new FirstItemInListDefn(), new ListLensDefn("a", "address")), (Object)this.lensParser.apply((Object)"child/childClass,{firstItem},a/*address"));
    }

    @Test
    public void testLensLineParser() {
        Assert.assertEquals((Object)new LensLine("lens1", List.of(new ViewLensDefn("child", "childClass"), new StringLensDefn("line1"))), (Object)this.lineParser.apply((Object)"lens1=child/childClass,line1/string"));
    }

    @Test
    public void testLensStoreParser() {
        List<String> lines = List.of("line1=child/childClass,line1/double", "line1=child/childClass,line1/string", "line3=child1/childClass,line1/integer");
        Assert.assertEquals((Object)Lists.map(lines, s -> (LensLine)this.lineParser.apply(s)), (Object)((LensDefnStore)this.storeParser.apply((Object)Lists.join(lines, (String)"\n"))).defns);
    }
}

