/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.annotationProcessors;

import java.util.Optional;
import javax.lang.model.element.Element;
import one.xingyi.core.annotationProcessors.ElementFail;
import one.xingyi.core.annotationProcessors.IElementToFieldDom;
import one.xingyi.core.annotationProcessors.IViewDefnNameToViewName;
import one.xingyi.core.annotations.Field;
import one.xingyi.core.codeDom.FieldDom;
import one.xingyi.core.names.IServerNames;
import one.xingyi.core.typeDom.TypeDom;
import one.xingyi.core.utils.LoggerAdapter;
import one.xingyi.core.utils.Strings;
import one.xingyi.core.validation.Result;

abstract class AbstractElementToFieldDom
implements IElementToFieldDom {
    final LoggerAdapter loggerAdapter;
    final IServerNames serverNames;

    abstract String findLensName(String var1, String var2);

    abstract Result<String, String> findLensPath(String var1, String var2);

    @Override
    public Result<ElementFail, FieldDom> apply(Element element, IViewDefnNameToViewName viewNamesMap) {
        String fieldType = element.asType().toString();
        String fieldName = element.getSimpleName().toString();
        Result<String, TypeDom> typeDom = TypeDom.create(this.serverNames, fieldType, viewNamesMap);
        return ElementFail.lift(element, typeDom.flatMap(td -> {
            Field annotation = element.getAnnotation(Field.class);
            String lensName = this.findLensName(fieldName, Optional.ofNullable(annotation).map(Field::lensName).orElse(""));
            String rawLensPath = Optional.ofNullable(annotation).map(Field::lensPath).orElse("");
            return this.findLensPath(td.lensDefn(fieldName), rawLensPath).flatMap(lensPath -> {
                Boolean readOnly = Optional.ofNullable(annotation).map(Field::readOnly).orElse(false);
                String javascriptBody = Strings.from(Optional.ofNullable(annotation).map(Field::javascript).orElse(""), "return lens('" + fieldName + "');");
                String javascript = "function " + lensName + "(){" + javascriptBody + "};";
                Boolean templated = Optional.ofNullable(annotation).map(a -> a.templated()).orElse(false);
                Boolean deprecated = element.getAnnotation(Deprecated.class) != null;
                return Result.succeed(new FieldDom((TypeDom)td, fieldName, readOnly, lensName, (String)lensPath, javascript, templated, deprecated));
            });
        }));
    }

    public AbstractElementToFieldDom(LoggerAdapter loggerAdapter, IServerNames serverNames) {
        this.loggerAdapter = loggerAdapter;
        this.serverNames = serverNames;
    }
}

