/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.annotationProcessors;

import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import one.xingyi.core.annotationProcessors.ElementFail;
import one.xingyi.core.annotationProcessors.IElementToViewNames;
import one.xingyi.core.names.IServerNames;
import one.xingyi.core.names.ViewNames;
import one.xingyi.core.sdk.IXingYiViewDefn;
import one.xingyi.core.utils.Strings;
import one.xingyi.core.validation.Result;

class SimpleElementToViewNames
implements IElementToViewNames {
    private IServerNames serverNames;

    public SimpleElementToViewNames(IServerNames serverNames) {
        this.serverNames = serverNames;
    }

    Result<String, String> findEntityName(TypeElement viewElement) {
        for (TypeMirror typeMirror : viewElement.getInterfaces()) {
            String interfaceName = typeMirror.toString();
            if (!interfaceName.startsWith(IXingYiViewDefn.class.getName())) continue;
            return Result.succeed(Strings.extractFromOptionalEnvelope(IXingYiViewDefn.class.getName() + "<", ">", interfaceName));
        }
        return Result.failwith("could not find interface for " + viewElement.asType() + " that was IXingYiViewDefn<> in " + viewElement.getInterfaces());
    }

    @Override
    public Result<ElementFail, ViewNames> apply(TypeElement element) {
        return ElementFail.lift(element, this.findEntityName(element).map(en -> this.serverNames.viewName(element.asType().toString(), (String)en)));
    }
}

