/*
 * Decompiled with CFR 0.152.
 */
package one.xingyi.core.annotationProcessors;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import one.xingyi.core.annotationProcessors.ElementFail;
import one.xingyi.core.annotationProcessors.ElementToBundle;
import one.xingyi.core.annotationProcessors.IElementsToMapOfViewDefnToView;
import one.xingyi.core.annotationProcessors.IViewDefnNameToViewName;
import one.xingyi.core.annotations.Resource;
import one.xingyi.core.annotations.Server;
import one.xingyi.core.annotations.ValidateLens;
import one.xingyi.core.annotations.ValidateManyLens;
import one.xingyi.core.annotations.View;
import one.xingyi.core.codeDom.CodeDom;
import one.xingyi.core.codeDom.ResourceDom;
import one.xingyi.core.codeDom.ServerDom;
import one.xingyi.core.codeDom.ViewDom;
import one.xingyi.core.filemaker.ClientResourceCompanionFileMaker;
import one.xingyi.core.filemaker.ClientResourceFileMaker;
import one.xingyi.core.filemaker.ClientViewCompanionFileMaker;
import one.xingyi.core.filemaker.ClientViewImplFileMaker;
import one.xingyi.core.filemaker.ClientViewInterfaceFileMaker;
import one.xingyi.core.filemaker.CodeDomDebugFileMaker;
import one.xingyi.core.filemaker.FileDefn;
import one.xingyi.core.filemaker.HttpServiceFileMaker;
import one.xingyi.core.filemaker.IFileMaker;
import one.xingyi.core.filemaker.ServerCompanionFileMaker;
import one.xingyi.core.filemaker.ServerControllerFileMaker;
import one.xingyi.core.filemaker.ServerFileMaker;
import one.xingyi.core.filemaker.ServerInterfaceFileMaker;
import one.xingyi.core.filemaker.ServerResourceFileMaker;
import one.xingyi.core.filemaker.ViewDomDebugFileMaker;
import one.xingyi.core.monad.CompletableFutureDefn;
import one.xingyi.core.monad.MonadDefn;
import one.xingyi.core.names.EntityNames;
import one.xingyi.core.names.IClassNameStrategy;
import one.xingyi.core.names.IPackageNameStrategy;
import one.xingyi.core.names.IServerNames;
import one.xingyi.core.names.ViewNames;
import one.xingyi.core.sdk.IXingYiResourceDefn;
import one.xingyi.core.sdk.IXingYiViewDefn;
import one.xingyi.core.utils.Files;
import one.xingyi.core.utils.Lists;
import one.xingyi.core.utils.LoggerAdapter;
import one.xingyi.core.utils.Sets;
import one.xingyi.core.utils.Strings;
import one.xingyi.core.utils.WrappedException;
import one.xingyi.core.validation.Result;
import one.xingyi.core.validation.Valid;

public class XingYiAnnotationProcessor
extends AbstractProcessor {
    final IServerNames names = IServerNames.simple(IPackageNameStrategy.simple, IClassNameStrategy.simple);
    final IElementsToMapOfViewDefnToView elementsToMapOfViewDefnToView = IElementsToMapOfViewDefnToView.simple(this.names);
    private Types typeUtils;
    private Elements elementUtils;
    private Filer filer;
    private Messager messager;
    Valid<ElementFail, TypeElement> checkRootUrlStartsWithHost = this.check(e -> this.emptyOr(e.getAnnotation(Resource.class).rootUrl(), url -> url.startsWith("{host}")), e -> "Root Url needs to start with {host}");
    Valid<ElementFail, TypeElement> checkRootUrlHasId = this.check(e -> this.emptyOr(e.getAnnotation(Resource.class).rootUrl(), url -> url.contains("{id}")), e -> "Root Url needs to contain {id}");
    Valid<ElementFail, TypeElement> checkElementIsAnInterface = this.check(e -> e.getKind() == ElementKind.INTERFACE, e -> "Must be an interface");
    Valid<ElementFail, TypeElement> checkNameStartsWithI = this.check(e -> e.getSimpleName().toString().startsWith("I"), e -> "Name must start with an I");
    Valid<ElementFail, TypeElement> checkNameEndsWithDefn = this.check(e -> e.getSimpleName().toString().endsWith("Defn"), e -> "Name must end with Defn");
    Valid<ElementFail, TypeElement> initialResourceElementChecks = Valid.compose(this.initialTypeElementChecks(IXingYiResourceDefn.class), this.checkRootUrlStartsWithHost, this.checkRootUrlHasId);
    Valid<ElementFail, TypeElement> initialViewElementChecks = this.initialTypeElementChecks(IXingYiViewDefn.class);

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
        processingEnv.getOptions();
    }

    static <T extends Element> Comparator<T> comparator() {
        return (a, b) -> a.asType().toString().compareTo(b.asType().toString());
    }

    boolean emptyOr(String s, Function<String, Boolean> fn) {
        return s.isEmpty() || fn.apply(s) != false;
    }

    Valid<ElementFail, TypeElement> check(Function<TypeElement, Boolean> checkFn, Function<TypeElement, String> message) {
        return Valid.check(checkFn, message, (e, s) -> new ElementFail((String)s, (Element)e));
    }

    Valid<ElementFail, TypeElement> checkImplements(String className) {
        return this.check(e -> Lists.find(e.getInterfaces(), i -> i.toString().startsWith(className)).isPresent(), e -> "Must extend " + className);
    }

    Valid<ElementFail, TypeElement> initialTypeElementChecks(Class<?> obligatoryInterface) {
        return Valid.compose(this.checkElementIsAnInterface, this.checkNameStartsWithI, this.checkNameEndsWithDefn, this.checkImplements(obligatoryInterface.getName()));
    }

    private List<TypeElement> getCheckedElements(Class<? extends Annotation> annotation, RoundEnvironment env, LoggerAdapter log, Valid<ElementFail, TypeElement> valid) {
        List<? extends Element> elements = Sets.sortedList(env.getElementsAnnotatedWith(annotation), XingYiAnnotationProcessor.comparator());
        List<ElementFail> elementFails = Valid.checkAll(elements, valid);
        Lists.foreach(elementFails, log::error);
        return elements;
    }

    private List<ResourceDom> makeResourceDomResults(RoundEnvironment env, LoggerAdapter log, ElementToBundle bundle, IViewDefnNameToViewName viewNamesMap) {
        List<TypeElement> elements = this.getCheckedElements(Resource.class, env, log, this.initialResourceElementChecks);
        return log.logFailuresAndReturnSuccesses(Lists.map(elements, e -> (Result)bundle.elementToEntityDom((EntityNames)bundle.elementToEntityNames().apply(e)).apply(e, viewNamesMap)));
    }

    private List<ViewDom> makeViewDoms(RoundEnvironment env, LoggerAdapter log, ElementToBundle bundle, IViewDefnNameToViewName viewNamesMap) {
        List<TypeElement> viewElements = this.getCheckedElements(View.class, env, log, this.initialViewElementChecks);
        return log.logFailuresAndReturnSuccesses(Lists.map(viewElements, v -> ((Result)bundle.elementToViewNames().apply(v)).flatMap(vn -> bundle.elementToViewDom((ViewNames)vn).apply((TypeElement)v, viewNamesMap))));
    }

    Result<String, FileDefn> makeServer(ServerDom serverDom) {
        return new ServerFileMaker().apply(serverDom);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annoations, RoundEnvironment env) {
        CompletableFutureDefn monadDefn = new CompletableFutureDefn();
        LoggerAdapter log = LoggerAdapter.fromMessager(this.messager);
        ElementToBundle bundle = ElementToBundle.simple(log);
        log.info("Processing XingYi Annotations");
        try {
            IViewDefnNameToViewName viewNamesMap = (IViewDefnNameToViewName)this.elementsToMapOfViewDefnToView.apply(Sets.sortedList(env.getElementsAnnotatedWith(View.class), XingYiAnnotationProcessor.comparator()));
            CodeDom codeDom = new CodeDom(monadDefn, this.makeResourceDomResults(env, log, bundle, viewNamesMap), this.makeViewDoms(env, log, bundle, viewNamesMap));
            log.info("Made codeDom: " + codeDom);
            List serverDoms = log.logFailuresAndReturnSuccesses(Lists.map(Sets.toList(env.getElementsAnnotatedWith(Server.class)), e1 -> ServerDom.create(this.names, e1, codeDom)));
            List codeContent = log.logFailuresAndReturnStringSuccesses(this.makeContent(log, codeDom));
            List systemContent = log.logFailuresAndReturnStringSuccesses(Lists.map(serverDoms, sd -> this.makeServer((ServerDom)sd)));
            this.makeHttpService("one.xingyi.core.httpClient", monadDefn).forEach(x -> {
                try {
                    this.makeClassFile((FileDefn)x);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            Lists.foreach(Lists.append(systemContent, codeContent), this::makeClassFile);
            this.validateLens(env, log, codeDom);
        }
        catch (Exception e) {
            Throwable unwrapped = WrappedException.unWrap(e);
            log.error("In Annotation Processor\n" + Strings.getFrom(unwrapped::printStackTrace));
        }
        return false;
    }

    Result<String, FileDefn> makeHttpService(String packageName, MonadDefn monadDefn) {
        return new HttpServiceFileMaker(packageName).apply(monadDefn);
    }

    List<Result<String, FileDefn>> makeContent(LoggerAdapter log, CodeDom codeDom) {
        List<IFileMaker> entityFileMakes = Arrays.asList(new CodeDomDebugFileMaker(), new ServerInterfaceFileMaker(), new ServerResourceFileMaker(), new ClientResourceFileMaker(), new ServerCompanionFileMaker(), new ClientResourceCompanionFileMaker(codeDom.monadDefn), new ServerControllerFileMaker(codeDom.monadDefn));
        List<ClientViewImplFileMaker> viewFileMakers = List.of(new ViewDomDebugFileMaker(), new ClientViewInterfaceFileMaker(codeDom.monadDefn), new ClientViewCompanionFileMaker(codeDom.monadDefn), new ClientViewImplFileMaker());
        List fromResources = Lists.flatMap(codeDom.resourceDoms, resourceDom -> Lists.map(entityFileMakes, f1 -> f1.apply(resourceDom)));
        List fromViews = Lists.flatMap(codeDom.viewsAndDoms, viewDom -> Lists.map(viewFileMakers, f11 -> f11.apply(viewDom)));
        return Lists.append(fromResources, fromViews);
    }

    void makeClassFile(FileDefn fileDefn) {
        WrappedException.wrap(() -> {
            JavaFileObject builderFile = this.filer.createSourceFile(fileDefn.packageAndClassName.asString(), new Element[0]);
            Files.setText(() -> new PrintWriter(builderFile.openWriter()), fileDefn.content);
        });
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(Resource.class.getName(), View.class.getName(), Server.class.getName(), ValidateManyLens.class.getName());
    }

    private void validateLens(RoundEnvironment env, LoggerAdapter log, CodeDom codeDom) throws IOException {
        Set<? extends Element> validate = env.getElementsAnnotatedWith(ValidateManyLens.class);
        for (Element element : validate) {
            for (ValidateLens annotation : element.getAnnotation(ValidateManyLens.class).value()) {
                try {
                    String msg;
                    FileObject fileObject = this.filer.getResource(StandardLocation.CLASS_PATH, "", annotation.value());
                    File outputFile = new File(fileObject.toUri().toURL().getFile());
                    File file = new File(outputFile.getParentFile().getParentFile().getParentFile(), "src/main/resources/" + annotation.value());
                    String text = Files.getText(file);
                    HashSet<String> expectedLens = new HashSet<String>(Lists.filter(Arrays.asList(text.split("\n")), l -> l.length() > 0));
                    HashSet actualLens = new HashSet(Lists.flatMap(codeDom.resourceDoms, ed -> ed.fields.withDeprecatedmap(fd -> fd.lensName)));
                    actualLens.add("lens_EntityDetails_urlPattern");
                    HashSet<String> originalExpectedLens = new HashSet<String>(expectedLens);
                    HashSet<String> originalActualsLens = new HashSet<String>(actualLens);
                    expectedLens.removeAll(originalActualsLens);
                    if (expectedLens.size() > 0) {
                        msg = "(" + annotation.value() + ") Sometimes this is caused by incremental compilation\nMissing lens " + expectedLens + "\nActual lens are\n" + Sets.sortedString(originalActualsLens, ", ");
                        if (annotation.error()) {
                            log.error(element, msg);
                        } else {
                            log.warning(element, msg);
                        }
                    }
                    if (!annotation.exact()) continue;
                    actualLens.removeAll(originalExpectedLens);
                    if (actualLens.size() <= 0) continue;
                    msg = "(" + annotation.value() + ") There are lens supported " + actualLens + " that aren't in the validation file\nActual lens are\n" + Sets.sortedString(originalActualsLens, ", ");
                    if (annotation.error()) {
                        log.error(element, msg);
                        continue;
                    }
                    log.warning(element, msg);
                }
                catch (FileNotFoundException ex) {
                    log.error(element, "Cannot find file for " + annotation.value() + ". It should be in the root class path. For example in src/main/resources ");
                }
            }
        }
    }
}

